unit M_Fon;

interface
uses
  OMEGA, M_Game, Setup, LexUtils;
type
  Tkomet = record
    D : oeRect;
    A, S : byte;
    C : integer;
  end;
  Tstar = record
    D : oeRect;
    A, C : byte;
    S : integer;
  end;
  TVStar = record
    D : oeRect;
    A : byte;
    Angle, T, C, PA : integer;
  end;

Procedure ProcFon;
Procedure DrawFon;
Procedure InitFon;

const
  MofKomet = 10;
  MofStar  = 70;
var
  Komet : array of Tkomet;
  Star  : array of TStar;
  VStar : TVstar;
implementation

Procedure SetKom(I : byte);
begin
  with Komet[I] do
    begin
      D.Height:=10 + random(51);
      D.Width:=D.Height / 2.5 - random(3);
      D.Y:=-D.Height - random(300);
      D.X:=-10 + random((WinW+10) div 20)*20;
      A:=100+random(156);
      S:=random(5)+5;
    end;
end;

Procedure AddKom;
var
  I : byte;
begin
  SetLength(Komet,MofKomet+1);
  for I:=0 to MofKomet do
  SetKom(I);
end;

Procedure ProcKom;
var
  I : byte;
begin
  for I:=0 to MofKomet do
  begin
    app(Komet[I].D.Y, Komet[I].S/0.5);
    app(Komet[I].D.Height, random(2)/10);
    if Komet[I].D.Y > WinH + Komet[I].D.Height + 10 then
    SetKom(I);
  end;
end;

Procedure DrawKom;
var
  I : byte;
begin
  for I:=0 to MofKomet do
  with Komet[I] do
  Omega.SSprite_Draw(Texture[Texkomet], D.X, D.Y, D.Width, D.Height, A);
end;

Procedure AddStar;
var
  I : byte;
begin
  SetLength(Star, MofStar+1);
  for I:=0 to MofStar do
  with Star[I] do
  begin
    D.X:=random(WinW div 5) *5;
    D.Y:=random(WinH div 5) *5;
    D.Width:=5+random(10);
    D.Height:=D.Width;
    A:=10+random(156);
    S:=random(360);
  end;
end;

Procedure ProcStar;
var
  I : byte;
begin
  for I:=0 to MofStar do
  with Star[I] do
   dec(A, 2)
end;

Procedure DrawStar;
var
  I : byte;
begin
  for I:=0 to MofStar do
  with Star[I] do
  Omega.SSprite_Draw(Texture[TexStar], D.X, D.Y, D.Width, D.Height, A, S);
end;

Procedure addVStar;
begin
  VStar.D.Width:=100+random(50);
  VStar.D.Height:=VStar.D.Width;
  VStar.D.X:=random(WinW-300)+150;
  VStar.D.Y:=random(WinH-300)+150;
  VStar.Angle:=random(360);
  VStar.PA:=random(7)-3;
  if VStar.PA=0 then VStar.PA:=5;
  VStar.A:=100+random(156);
  VStar.T:=355+random(100);
  VStar.C:=random(1000000)+100;
end;

Procedure ProcVStar;
begin
  inc(VStar.Angle, VStar.PA);
  app(VStar.D.Height, VStar.PA / 10);
  VStar.D.Width:=VStar.D.Height+random(1);
  dec(Vstar.T);
  dec(VStar.A);
  if (Vstar.T<255) and (VStar.A<20)then
  addVStar;
end;

Procedure DrawVStar;
begin
  FX_SetColorMix( VStar.C );
  with VStar do
  SSprite_Draw(Texture[TexVStar], D.X, D.Y, D.Width, D.Height, A, Angle, FX_DEFAULT or FX_COLORMIX );
end;

Procedure ProcFon;
begin
  ProcVStar;
  ProcStar;
  ProcKom;

end;

Procedure DrawFon;
begin
  DrawVStar;
  DrawStar;
  DrawKom;

end;

Procedure InitFon;
begin
  AddStar;
  AddKom;
  addVStar;
end;

end.
