{------------------------------------------------------------------------------}
{ SibVRV
{ svGE Unit
{ Created 12.03.2001 by Vereshagin Roman Vladimirovich.
{ History:
{  VR - Unit Created
{------------------------------------------------------------------------------}
unit svGE_SoundChannels;

interface
uses svGE_SoundDriverClass;

function getnewhalftone(current,add : longint) : longint;
function getc2spd(finetune : word) : word;

const
{ Mixer data }
  maxinstr  = 256; { maximum number of voices   }
  maxchnls  = 32;  { maximum number of channels }

  vibrato_sine : array[0..63] of integer = (0,24,49,74,97,120,141,161,180,197,
                                         212,224,235,244,250,253,255,253,250,
                                         244,235,224,212,197,180,161,141,120,
                                         97,74,49,24,
                                         0,-24,-49,-74,-97,-120,-141,-161,-180,-197,
                                         -212,-224,-235,-244,-250,-253,-255,-253,-250,
                                         -244,-235,-224,-212,-197,-180,-161,-141,-120,
                                         -97,-74,-49,-24);
  xm_sine : array[0..127] of integer = (0,  6, 12, 18, 24, 31, 37, 43, 49, 55, 61, 68, 74, 79, 85, 91,
                                        97,103,109,114,120,125,131,136,141,146,151,156,161,166,171,175,
                                        180,184,188,193,197,201,204,208,212,215,218,221,224,227,230,233,
                                        235,237,240,242,244,245,247,248,250,251,252,253,253,254,254,254,
                                        255,254,245,254,253,253,252,251,250,248,247,245,244,242,240,237,
                                        235,233,230,227,224,221,218,215,212,208,204,201,197,193,188,184,
                                        180,175,171,166,161,156,151,146,141,136,131,125,120,114,109,103,
                                        97, 91, 85, 79 ,74, 68, 61, 55, 49, 43, 37, 31, 24, 18, 12,  6);

  stereomix = 51;      { how much percent MOD stereo mixing (value/100*255) }
  stdfreq   = 16574;   { Amiga PAL standard frequency                       }
  osc_freq  = 3546895;
  s3m_freq  = 14317056;
  xm_freq   = 14317456 div 2;

  channelval : array[0..maxchnls-1] of byte=(0,1,
                                             1,0,
                                             0,1,
                                             1,0,
                                             0,1,
                                             1,0,
                                             0,1,
                                             1,0,
                                             0,1,
                                             1,0,
                                             0,1,
                                             1,0,
                                             0,1,
                                             1,0,
                                             0,1,
                                             1,0);



  s3mtab : array[0..10,0..11] of word =
  ((27392,25856,24384,23040,21696,20480,19328,18240,17216,16256,15360,14496),
   (13696,12928,12192,11520,10848,10240, 9664, 9120, 8608, 8128, 7680, 7248),
    (6848, 6464, 6096, 5760, 5424, 5120, 4832, 4560, 4304, 4064, 3840, 3624),
    (3424, 3232, 3048, 2880, 2712, 2560, 2416, 2280, 2152, 2032, 1920, 1812),
    (1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016,  960,  906),
     (856,  808,  762,  720,  678,  640,  604,  570,  538,  508,  480,  453),
     (428,  404,  381,  360,  339,  320,  302,  285,  269,  254,  240,  226),
     (214,  202,  190,  180,  170,  160,  151,  143,  135,  127,  120,  113),
     (107,  101,   95,   90,   85,   80,   75,   71,   67,   63,   60,   56),
      (53,   50,   47,   45,   42,   40,   37,   35,   33,   31,   30,   28),
      (26,   25,   23,   22,   21,   20,   18,   17,   16,   15,   15,   14));

   xmtab : array[0..120] of word =
   (907,900,894,887,881,875,868,862,856,850,844,838,832,826,820,814,
    808,802,796,791,785,779,774,768,762,757,752,746,741,736,730,725,
    720,715,709,704,699,694,689,684,678,675,670,665,660,655,651,646,
    640,636,632,628,623,619,614,610,604,601,597,592,588,584,580,575,
    570,567,563,559,555,551,547,543,538,535,532,528,524,520,516,513,
    508,505,502,498,494,491,487,484,480,477,474,470,467,463,460,457,
    454,450,447,444,441,437,434,431,428,425,422,419,416,413,410,407,
    404,401,398,395,393,390,387,384,381);

  mdkeyoff   = $FFFF;
  mdnotavail = $FFFF;


type

  { << Added by Raid >> }

  EDataType = Array [0 .. 11] OF
              Record
                X, Y: Word;
              End; { EDataType }

  TEnvelope = Record
    Points:   Byte;
    Sustain:  Byte;
    LStart:   Byte;
    LEnd:     Byte;
    EStat:    Byte;
    EData:    EDataType;
  End; { TEnvelope }

  TEnvelopeCH = Record
    Active:   Boolean;
    CurPoint: Byte;
    DestX:    longint;
    DestY:    longint;
    CurY:     Word;
    ECounter: integer;
    Envelope: TEnvelope;
  End; { TEnvelopeCH }

  { << End >> }

  pchannelset = ^tchannelset;
  tchannelset = object
    channel : array[0..maxchnls-1] of record

      freq         : longint;

      period       : longint;
      portaslide   : integer;
      bportaslide  : boolean;
      lportaslide  : integer;

      { XM likes them separated }
      porta_up     : integer;
      porta_dn     : integer;

      finepslide   : integer;
      bfinepslide  : boolean;
      lfinepslide  : integer;

      { << Added by Raid >> }
      PanCounter   : Integer;
      PanSlide     : Integer;
      BPanSlide    : Boolean;
      { << End >> }

      porta        : boolean;
      portaspeed   : longint;
      portanote    : longint;
      { << Added by Raid >> }
      { << End >> }

      vibrato      : boolean;
      vibratotype  : byte;
      vibratopos   : byte;
      vibratospeed : byte;
      vibratodepth : byte;

      tremolo      : boolean;
      tremolotype  : byte;
      tremolopos   : integer;
      tremolospeed : integer;
      tremolodepth : integer;

      volume       : integer;
      volumeslide  : integer;
      bvolumeslide : boolean;
      lvolumeslide : integer;

      finevslide   : integer;
      bfinevslide  : boolean;

      volcutcount  : integer;

      arpeggio     : boolean;
      arpeggiox    : byte;
      arpeggioy    : byte;

      lastsetpos   : longint;

      panning      : integer;

      voice        : word;
      sound        : tchannel;

      notedelay    : word;
      retrig       : byte;
      retrigtype   : byte;
      lretrig      : byte;

      lasteffect   : word;

      tuning       : integer;

      tremor       : boolean;
      tremorcount  : word;
      tremorx      : byte;
      tremory      : byte;

      fadeoutvol   : longint;
      volfade      : longint;
      keyfading    : boolean;
      envvol       : word;
      envpan       : integer;

      EnvelopeCH: Array [0 .. 1] OF TEnvelopeCH;

      { Auto vibrato variables }
      avitype      : byte;
      avisweep     : byte;
      avidepth     : byte;
      avispeed     : byte;
      avipos       : byte;
      avispos      : word;

      patternloop : record
        active   : boolean;
        count    : longint; { number of repeats, decreasing  }
        pattern  : longint; { pattern which is beeing looped }
        line     : longint; { starting line in pattern       }
      end;

    end;

    globalvol   : word;
    globalslide : integer;

    GVolCounter : Integer;
    GVolSlide   : Integer;
    BGVolSlide  : Boolean;

    instrument : array[1..maxinstr] of record
                  name       : string[30];
                  open       : boolean;
                  s          : pointer;
                  loopstart,
                  loopend,
                  size       : longint;
                  isword     : boolean; { indicates bytewise sample offset }
                  volume     : integer;
                  ofreq      : longint;
                  tuning     : longint;
                  relnote    : integer;
                  panning    : integer;
                  volfade    : longint;

                  { XM FX }
                  Envelope: Array [0 .. 1] OF TEnvelope;
                  avitype    : byte;
                  avisweep   : byte;
                  avidepth   : byte;
                  avispeed   : byte;
                end;

    constructor init;
    destructor  done;
    function    sample_available(smp : word) : boolean;
    procedure   play(chn,voice,frequency,volume : longint);
    procedure   stop(chn : word);
    procedure   setfrequency(chn,frequency : longint);
    procedure   setvolume(chn,volume : word);
    procedure   setpos(chn,ofs : longint);
  end;

implementation

function getnewhalftone(current,add : longint) : longint;
const
  halftoneroot = 1.059463094;

begin
  getnewhalftone := round(current*exp((-add)*ln(halftoneroot)));
end;

function getc2spd(finetune : word) : word;
begin
  case finetune of
     0 : getc2spd := 8363;
     1 : getc2spd := 8413;
     2 : getc2spd := 8463;
     3 : getc2spd := 8529;
     4 : getc2spd := 8581;
     5 : getc2spd := 8651;
     6 : getc2spd := 8723;
     7 : getc2spd := 8757;
     8 : getc2spd := 7895;
     9 : getc2spd := 7941;
    10 : getc2spd := 7985;
    11 : getc2spd := 8046;
    12 : getc2spd := 8107;
    13 : getc2spd := 8169;
    14 : getc2spd := 8232;
    15 : getc2spd := 8280;
    else  getc2spd := 8363;
  end;
end;

constructor tchannelset.init;
var
  i : integer;

begin
  fillchar(channel,sizeof(channel),0);
  fillchar(instrument,sizeof(instrument),0);
  for i := 0 to maxchnls-1 do channel[i].panning := channelval[i]*512-256;
  for i := 0 to maxchnls-1 do if (channel[i].panning < 0) then
    inc(channel[i].panning,stereomix) else dec(channel[i].panning,stereomix);
  for i := 0 to maxchnls-1 do with channel[i] do
  begin
    envvol     := 256;
    envpan     := 0;
    fadeoutvol := 65536;
  end;
  globalvol := 256;
end;

destructor tchannelset.done;
var
  i : integer;

begin
  for i := 1 to maxinstr do if
  (instrument[i].open)and(assigned(instrument[i].s)) then freemem(instrument[i].s);
end;

function tchannelset.sample_available(smp : word) : boolean;
begin
  sample_available := (instrument[smp].size <> 0)and(instrument[smp].open);
end;

procedure tchannelset.play(chn,voice,frequency,volume : longint);
begin
  if (voice <> channel[chn].voice) then
  begin
    channel[chn].tuning := instrument[voice].tuning;
    channel[chn].voice  := voice;
  end;

  { Check if given sample was valid }
  if (instrument[voice].size = 0)or(instrument[voice].s = nil) then
  begin
    channel[chn].sound.stop;
    exit;
  end;

  { Reset all sample runtime variables }
  with channel[chn] do
  begin
    vibratopos   := 0;
    avipos       := 0;
    avispos      := 0;
    tremolopos   := 0;
    if (vibratotype and 4 = 0) then vibratotype := 0;
    if (tremolotype and 4 = 0) then tremolotype := 0;
  end;

  channel[chn].sound.setsample(instrument[voice].s,instrument[voice].size*2,instrument[voice].ofreq);
  channel[chn].sound.setloop(instrument[voice].loopstart,instrument[voice].loopend);

  channel[chn].volume     := volume;
  channel[chn].fadeoutvol := 65536;
  channel[chn].keyfading  := false;
  channel[chn].volfade    := instrument[voice].volfade;


  { Set auto vibrato }
  with channel[chn] do
  begin
    avitype  := instrument[voice].avitype;
    avisweep := instrument[voice].avisweep;
    avidepth := instrument[voice].avidepth;
    avispeed := instrument[voice].avispeed;
  end;

  setvolume(chn,volume);
  setfrequency(chn,frequency);
  channel[chn].sound.play;
end;

procedure tchannelset.stop(chn : word);
begin
  channel[chn].sound.stop;
end;

procedure tchannelset.setfrequency(chn,frequency : longint);
begin
  channel[chn].sound.setfrequency(frequency);
end;

procedure tchannelset.setvolume(chn,volume : word);
var
  finalvol,
  finalpan  : longint;

begin

  if (volume > 64) then volume := 64;

  finalvol := (longint(volume) shl 1 * globalvol * channel[chn].envvol) shr 8;
  finalvol := (finalvol*(channel[chn].fadeoutvol shr 8)) shr 16;

  finalpan := longint(channel[chn].panning)+channel[chn].envpan;
  {!!
  Check this.. documentation says
  FinalPan = Pan + ( (EnvelopePan-32)*(128-Abs(Pan-128)) / 32 );
  }

  if (finalpan < -255) then finalpan := -255 else
  if (finalpan > 255) then finalpan := 255;

  channel[chn].sound.setsoundpos(Finalpan, 0, Finalvol);

end;

procedure tchannelset.setpos(chn,ofs : longint);
begin
  channel[chn].sound.play;
  if (ofs > instrument[channel[chn].voice].size) then ofs := instrument[channel[chn].voice].size;
  channel[chn].sound.setpos(ofs);
end;

end.
