{------------------------------------------------------------------}
{                                                                  }
{                  - 1.0                  }
{                                                                  }
{       : 07.08.08                                  }
{         : http://www.igdc.ru/                       }
{                 : Sovetnik                                  }
{            : http://sovetnik.freetzi.com/              }
{                                                                  }
{------------------------------------------------------------------}

program grobik;

uses
  Windows,
  Messages,
  OpenGL,
  PlayMIDI,
  sovDDS;

type
  TByteArray = array [0..32767] of Byte;
  pByteArray = ^TByteArray;
  protiv = record
    x, y: GLfloat;
    ptype: Integer;
    life: Integer;
    speed: Glfloat; // -1..1 * k
  end;
  shoot = record
    x, y: GLfloat;
  end;
  records = record      //    
    player: String[20]; //   
    pscore: Word;       //  
  end;
  particle = record
    life: Integer;
    x, y: GLfloat;
    dx, dy: GLfloat;
  end;


const
  WND_TITLE = 'Smile-o-fag';
  FPS_TIMER = 1;                     // Timer to calculate FPS
  FPS_INTERVAL = 1000;               // Calculate FPS every 1000 ms
  GAME_TIMER = 99;
  GAME_INTERVAL = 50;

  screenWidth = 800;
  screenHeight = 600;
  wtex = 512;
  w: GLfloat = 32;

  tca: array[0..31] of GLfloat = (0.5, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0, 0.5,
                                  1.0, 0.5, 1.0, 0.0, 0.5, 0.0, 0.5, 0.5,
                                  0.5, 1.0, 0.5, 0.5, 0.0, 0.5, 0.0, 1.0,
                                  1.0, 1.0, 1.0, 0.5, 0.5, 0.5, 0.5, 1.0);
  lr: array[0..15] of GLfloat  = (0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0,
                                  1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);

  maxx = 512-64;
  minx = 32;
  maxy = 512+32;

var
  h_Wnd  : HWND;                     //  
  h_DC   : HDC;                      //    ( WinApi, !)
  h_RC   : HGLRC;                    // "OpenGL rendering context" (     :))
  keys : Array[0..255] of Boolean;   //   
  mbuttons : Byte;                   //   
  FPSCount : Integer = 0;            //   FPS
  ElapsedTime : Integer;             //     (   FPS)
  mpos, mchan : TPoint;              //  
  base: GLuint;

  //Texs
  back: TDDS;
  enem: array of TDDS;
  pers: TDDS;
  water: TDDS;
  stex: TDDS;
  EffectTex: GLuint;

  x: GLfloat;  //      
  y: GLfloat;
  sspeed: GLfloat = 10;
  lives: Byte = 3;

  ani: Byte = 0;
  p: array of protiv;
  s: array of shoot;
  antis: array of shoot;
  mapw, maph: Integer;
  zader: Integer = 0; //  
  score: Integer = 0;
  paused: Boolean = false;
  win: Boolean = false;  //  
  lose: Boolean = false; // !
  levelnum: Integer = 1; //  

  maxenemy: Integer; // -  
  maxlevel: Integer; // - 
  top: array[0..9] of records;    //  
  sRecord: String;                //  
  c: Byte = 10; //    

  part: array of particle;
  shake: Integer = 0;


procedure glGenTextures (n: GLsizei; textures: PGLuint); stdcall; external opengl32;
procedure glBindTexture (target: GLEnum; texture: GLuint); stdcall; external opengl32;
procedure glDeleteTextures (n: GLsizei; textures: PGLuint); stdcall; external opengl32;
procedure glCopyTexImage2D (target: GLenum; level: GLint; internalFormat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei; border: GLint); stdcall; external opengl32;

function IntToStr(Num : Integer) : String;
begin
  Str(Num, result);
end;

{------------------------------------------------------------------}
{                              }
{------------------------------------------------------------------}
procedure BuildFont;
var font : HFONT;
begin
  base := glGenLists(224);

  font := CreateFont(-26,
		     0,
		     0,
		     0,
		     FW_BOLD,
		     0,
		     0,
		     0,
		     DEFAULT_CHARSET,                
		     OUT_TT_PRECIS,
		     CLIP_DEFAULT_PRECIS,
		     ANTIALIASED_QUALITY,
		     FF_DONTCARE or DEFAULT_PITCH,
		     'Arial');
  SelectObject(h_DC, font);
  wglUseFontBitmaps(h_DC, 32, 224, base);
end;

procedure KillFont;
begin
  glDeleteLists(base, 224);
end;

procedure glWrite(X, Y: GLUint; text: String);
begin
  glDisable(GL_TEXTURE_2D);
  glColor3f(0.1, 0.1, 0.5);
  glRasterPos2i(X, Y);          //  
  glPushAttrib(GL_LIST_BIT);    //      
  glListBase(base - 32);        //    
  glCallLists(length(text), GL_UNSIGNED_BYTE, PChar(text));  // ,  
  glPopAttrib();                //   "" 
  glColor3f(1.0, 1.0, 1.0);
  glEnable(GL_TEXTURE_2D);
end;

{------------------------------------------------------------------}
{                                                  }
{------------------------------------------------------------------}

procedure DelParticle(i: Integer);
var
  t: particle;
begin
  if length(part) > 1 then
  begin
    t := part[length(part) - 1];
    part[length(part) - 1] := part[i];
    part[i] := t;
  end;
  SetLength(part, length(part) - 1);
end;

procedure CreateParticle(x, y: GLfloat);
var
  i, l: Integer;
begin
  randomize;
  l := length(part);
  SetLength(part, l + 7);
  for i := 0 to 6 do
  begin
    part[l].x := x;
    part[l].y := y;
    part[l].life := 5;
    part[l].dx := random(10) - 5;
    part[l].dy := random(10) - 5;
    inc(l);
  end;
end;

procedure TimeParticle;
var
  i: Integer;
label a5;
begin
  i := 0;
  while i < length(part) do
  begin
    dec(part[i].life);
    if part[i].life < 0 then
    begin
      DelParticle(i);
      goto a5;
    end;
    part[i].x := part[i].x + part[i].dx;
    part[i].y := part[i].y + part[i].dy;
a5: inc(i);
  end;
end;

procedure DrawParticle;
var
  i: Integer;
begin
  for i := 0 to length(part) - 1 do
  begin
    stex.ShowTexture;
    glColor4f(0.0, 1.0, 0.0, part[i].life / 5);
    glBegin(GL_QUADS);
      glTexCoord2f(1.0, 1.0);
      glVertex2f(part[i].x, part[i].y);
      glTexCoord2f(1.0, 0.0);
      glVertex2f(part[i].x, part[i].y + w/4);
      glTexCoord2f(0.0, 0.0);
      glVertex2f(part[i].x + w/4, part[i].y + w/4);
      glTexCoord2f(0.0, 1.0);
      glVertex2f(part[i].x + w/4, part[i].y);
    glEnd();
  end;
end;

//   
procedure InputRecords;
begin
  back.ShowTexture;
  glBegin(GL_QUADS);
    glTexCoord2f(1.0, 1.0);
    glVertex2f(0, 0);
    glTexCoord2f(1.0, 0.0);
    glVertex2f(0, 512);
    glTexCoord2f(0.0, 0.0);
    glVertex2f(756, 512);
    glTexCoord2f(0.0, 1.0);
    glVertex2f(756, 0);
  glEnd();
  glWrite(100, 400, '  ');
  glWrite(100, 300, sRecord + '|');
end;

//  
procedure MainRecords;
var
  i: byte;  // 
begin
  back.ShowTexture;
  glBegin(GL_QUADS);
    glTexCoord2f(1.0, 1.0);
    glVertex2f(0, 0);
    glTexCoord2f(1.0, 0.0);
    glVertex2f(0, 512);
    glTexCoord2f(0.0, 0.0);
    glVertex2f(756, 512);
    glTexCoord2f(0.0, 1.0);
    glVertex2f(756, 0);
  glEnd();
  glDisable(GL_TEXTURE_2D);
  glWrite(240, 440, ' ');
  for i := 0 to 9 do
  begin
    glWrite(150, 100 + trunc(i * w), top[i].player);
    glWrite(500, 100 + trunc(i * w), IntToStr(top[i].pscore));
  end;
end;

//   
procedure NewRecord;
var
  f: file of records;  //  
  i: shortint;         // 
  j: byte;             //  
begin
  if score < 0 then
    score := 0;
  AssignFile(f, 'Data\scores.dat'); //     
  ReSet(f);
  for i := 0 to 9 do
    Read(f, top[i]);
  Close(f);
  i := -1;
  while top[i + 1].pscore < score do
    inc(i);
  if sRecord <> '' then
  begin
    if i > 0 then  //   
    begin
      for j := 1 to i do
        top[j - 1] := top[j];
    end;
    top[i].player := sRecord;
    top[i].pscore := score;
    AssignFile(f, 'Data\scores.dat'); //   
    ReWrite(f);
    for i := 0 to 9 do
      Write(f, top[i]);
    Close(f);
    sRecord := '';
    c := 30;
  end
  else
  begin
    if i >= 0 then
    begin
      sRecord := '';
      c := 20;
      exit;
    end;
    c := 30;
  end;
end;

//   , 
procedure InitLevel(filename: String);
var
  i, j: Integer;
  f: TextFile;
  t, l: Integer;
begin
  x := 3 * w;
  y := w;
  SetLength(s, 0);
  SetLength(antis, 0);
  SetLength(part, 0);

  AssignFile(f, filename);
  ReSet(f);
  ReadLn(f, mapw, maph);
  SetLength(p, 0);
  for i := 0 to maph - 1 do
  begin
    for j := 0 to mapw - 2 do
    begin
      Read(f, t);
      if t > 0 then
      begin
        l := length(p);
        SetLength(p, l + 1);
        p[l].ptype := t - 1;
        p[l].life := p[l].ptype * 2;
        p[l].x := j * w * 2 + w * 3;
        p[l].y := -i * w * 2 + w * 13;
        p[l].speed := 5;
      end;
    end;
    ReadLn(f, t);
    if t > 0 then
    begin
      l := length(p);
      SetLength(p, l + 1);
      p[l].ptype := t - 1;
      p[l].life := p[l].ptype * 2;
      p[l].x := j * w * 2 + w * 3;
      p[l].y := -i * w * 2 + w * 13;
      p[l].speed := 5;
    end;
  end;
  CloseFile(f);
end;

//  -   
procedure LoadConfig(filename: String);
var
  i: Integer;
  f: TextFile;
begin
  AssignFile(f, filename);
  ReSet(f);
  ReadLn(f, maxenemy, maxlevel);
  CloseFile(f);
  back := TDDS.Create;
  back.InitTexture('Data\back.dds');
  SetLength(enem, maxenemy);
  for i := 0 to maxenemy - 1 do
  begin
    enem[i] := TDDS.Create;
    enem[i].InitTexture('Data\enem' + IntToStr(i + 1) + '.dds');
  end;
  pers := TDDS.Create;
  pers.InitTexture('Data\mainpers.dds');
  stex := TDDS.Create;
  stex.InitTexture('Data\shoot.dds');

  StartSound(h_Wnd, 'Data\music.mid');

  InitLevel('Data\lvl1.txt');
end;

procedure NewShoot;
var
  l: Integer;
begin
  l := length(s);
  SetLength(s, l + 1);
  s[l].x := x + w/2;
  s[l].y := y + w;
end;

procedure DelShoot(i: Integer);
var
  t: shoot;
begin
  if length(s) > 1 then
  begin
    t := s[length(s) - 1];
    s[length(s) - 1] := s[i];
    s[i] := t;
  end;
  SetLength(s, length(s) - 1);
end;

procedure DelAntiShoot(i: Integer);
var
  t: shoot;
begin
  if length(antis) > 1 then
  begin
    t := antis[length(antis) - 1];
    antis[length(antis) - 1] := antis[i];
    antis[i] := t;
  end;
  SetLength(antis, length(antis) - 1);
end;

procedure DelProtiv(i: Integer);
var
  t: protiv;
begin
  CreateParticle(p[i].x, p[i].y);
  if p[i].ptype > 0 then
    shake := 5;
  inc(score, 4 * (p[i].ptype + 1));
  if length(p) > 1 then
  begin
    t := p[length(p) - 1];
    p[length(p) - 1] := p[i];
    p[i] := t;
  end;
  SetLength(p, length(p) - 1);
end;

function Collis(s: shoot; p: protiv): Boolean;
begin
  Result := true;
  if (s.x > p.x) and (s.x < p.x + w) and
     (s.y > p.y) and (s.y < p.y + w) then
    exit;
  if (s.x + w/4 > p.x) and (s.x + w/4 < p.x + w) and
     (s.y > p.y) and (s.y < p.y + w) then
    exit;
  if (s.x > p.x) and (s.x < p.x + w) and
     (s.y + w/2 > p.y) and (s.y + w/2 < p.y + w) then
    exit;
  if (s.x + w/4 > p.x) and (s.x + w/4 < p.x + w) and
     (s.y + w/2 > p.y) and (s.y + w/2 < p.y + w) then
    exit;
  Result := false;
end;

procedure StepShoot;
var
  i, j: Integer;
label
  a1;
begin
  i := 0;
  while i < length(s) do
  begin
    s[i].y := s[i].y + sspeed;
    // 
    //    
    if s[i].y > maxy then
    begin
      DelShoot(i);
      dec(score);
      goto a1;
    end;
    //   
    for j := 0 to length(p) - 1 do
    begin
      if Collis(s[i], p[j]) then
      begin
        dec(p[j].life);
        DelShoot(i);
        if p[j].life < 0 then
          DelProtiv(j);
        break;
      end;
    end;
a1:
    inc(i);
  end;
end;

procedure DropDead;
begin
  paused := true;
  lose := true;
  zader := 15;
end;

procedure NewAntiShoot(x, y: GLfloat);
var
  l: Integer;
begin
  l := length(antis);
  SetLength(antis, l + 1);
  antis[l].x := x + w/2;
  antis[l].y := y + w;
end;

procedure StepAntiShoot;
var
  i, j: Integer;
  t: protiv;
label
  a1;
begin
  i := 0;
  t.x := x;
  t.y := y;
  while i < length(antis) do
  begin
    antis[i].y := antis[i].y - sspeed;
    // 
    if antis[i].y < 0 then
    begin
      DelAntiShoot(i);
      goto a1;
    end;
    // 
    if Collis(antis[i], t) then
    begin
      DropDead;
      break;
    end;
a1:
    inc(i);
  end;
end;

procedure StepProtiv;
var
  i: Integer;
  t: Integer;
begin
  for i := 0 to length(p) - 1 do
  begin
    p[i].x := p[i].x + p[i].speed;
    if (p[i].x > maxx) or (p[i].x < minx) then
    begin
      p[i].speed := - p[i].speed;
      p[i].y := p[i].y - w;
      if abs(p[i].y - y) < 2 * w then
      begin
        DropDead;
        exit;
      end;
    end;
    if p[i].ptype > 3 then
    begin
      t := random(100 - p[i].ptype * 5);
      if t = 0 then
        NewAntiShoot(p[i].x, p[i].y - w);
    end;
  end;
end;

procedure FromTimer;
var
  i: Integer;
begin
if c = 10 then
begin
  if not(paused) then
  begin
    if length(p) = 0 then
    begin
      paused := true;
      win := true;
      zader := 15;
    end;
    inc(ani, 8);
    if ani >= 32 then ani := 0;
    StepShoot;
    StepAntiShoot;
    StepProtiv;
    TimeParticle;
  end;
  if win and (zader = 0) then
  begin
    inc(levelnum);
    win := false;
    paused := false;
    if levelnum <= maxlevel then
      InitLevel('Data\lvl' + IntToStr(levelnum) + '.txt')
    else
    begin
      NewRecord;
      exit;
    end;
  end;
  if lose and (zader = 0) then
  begin
    if lives > 0 then
    begin
      dec(lives);
      lose := false;
      paused := false;
      for i := 0 to length(p) - 1 do
        p[i].y := p[i].y + 2 * w;
      SetLength(s, 0);
      SetLength(antis, 0);
      SetLength(part, 0);
    end
    else
    begin
      NewRecord;
      exit;
    end;
  end;
  if zader > 0 then
    dec(zader);
  if shake > 0 then
    dec(shake);
end;
end;

procedure DrawEffect;
var
  tx, ty: GLfloat;
  i: Byte;
begin
  if shake > 0 then
  begin
    tx := random(10) - 5;
    ty := random(10) - 5;
  end
  else
  begin
    tx := 0;
    ty := 0;
  end;
  glEnable(GL_TEXTURE_2D);
  glColor4f(1.0, 1.0, 1.0, 0.0);
  glBindTexture(GL_TEXTURE_2D, EffectTex);
  glBegin(GL_QUADS);
    glTexCoord2f(0.0, 1.0); glVertex2f(tx,522+ty);
    glTexCoord2f(1.0, 1.0); glVertex2f(522+tx,522+ty);
    glTexCoord2f(1.0, 0.0); glVertex2f(522+tx,ty);
    glTexCoord2f(0.0, 0.0); glVertex2f(tx,ty);
  glEnd();
  glDisable(GL_TEXTURE_2D);
end;

procedure MainDraw;
var
  i: Integer;
  po: Integer;
  t: GLfloat;
begin
  glEnable(GL_BLEND);
  // 
  pers.ShowTexture;
  glBegin(GL_QUADS);
    glTexCoord2f(tca[ani], tca[ani + 1]);
    glVertex2f(x, y);
    glTexCoord2f(tca[ani + 2], tca[ani + 3]);
    glVertex2f(x, y + w);
    glTexCoord2f(tca[ani + 4], tca[ani + 5]);
    glVertex2f(x + w, y + w);
    glTexCoord2f(tca[ani + 6], tca[ani + 7]);
    glVertex2f(x + w, y);
  glEnd();
//  
for i := 0 to length(s) - 1 do
begin
  stex.ShowTexture;
  glBegin(GL_QUADS);
    glTexCoord2f(1.0, 1.0);
    glVertex2f(s[i].x, s[i].y);
    glTexCoord2f(1.0, 0.0);
    glVertex2f(s[i].x, s[i].y + w/2);
    glTexCoord2f(0.0, 0.0);
    glVertex2f(s[i].x + w/4, s[i].y + w/2);
    glTexCoord2f(0.0, 1.0);
    glVertex2f(s[i].x + w/4, s[i].y);
  glEnd();
end;
//  
for i := 0 to length(antis) - 1 do
begin
  stex.ShowTexture;
  glColor3f(0.0, 1.0, 1.0);
  glBegin(GL_QUADS);
    glTexCoord2f(1.0, 1.0);
    glVertex2f(antis[i].x, antis[i].y);
    glTexCoord2f(1.0, 0.0);
    glVertex2f(antis[i].x, antis[i].y + w/2);
    glTexCoord2f(0.0, 0.0);
    glVertex2f(antis[i].x + w/4, antis[i].y + w/2);
    glTexCoord2f(0.0, 1.0);
    glVertex2f(antis[i].x + w/4, antis[i].y);
  glEnd();
end;
//  
for i := 0 to length(p) - 1 do
begin
  enem[p[i].ptype].ShowTexture;
  if p[i].ptype = 0 then
    glColor3f(1.0, 1.0, 1.0)
  else
  begin
    t := p[i].life / p[i].ptype / 2;
    glColor4f(1.0, 1.0, 1.0, p[i].life / p[i].ptype / 2);
  end;
  po := round(abs(p[i].speed) / p[i].speed);
  po := (po + 1) * 4;
  glBegin(GL_QUADS);
    glTexCoord2f(lr[po], lr[po + 1]);
    glVertex2f(p[i].x, p[i].y);
    glTexCoord2f(lr[po + 2], lr[po + 3]);
    glVertex2f(p[i].x, p[i].y + w);
    glTexCoord2f(lr[po + 4], lr[po + 5]);
    glVertex2f(p[i].x + w, p[i].y + w);
    glTexCoord2f(lr[po + 6], lr[po + 7]);
    glVertex2f(p[i].x + w, p[i].y);
  glEnd();
end;
glColor3f(1.0, 1.0, 1.0);
DrawParticle;
glDisable(GL_BLEND);
end;

procedure GenEffect;
begin
  glViewport(0, 0, 768, 512);
  MainDraw;

  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, EffectTex);
  glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0, wtex, wtex, 0);

  glViewport(0, 0, screenWidth, screenHeight);
  glDisable(GL_TEXTURE_2D);
  glClear(GL_COLOR_BUFFER_BIT);
end;

procedure MainGame;
begin
  // 
  back.ShowTexture;
  glBegin(GL_QUADS);
    glTexCoord2f(1.0, 1.0);
    glVertex2f(0, 0);
    glTexCoord2f(1.0, 0.0);
    glVertex2f(0, 512);
    glTexCoord2f(0.0, 0.0);
    glVertex2f(512, 512);
    glTexCoord2f(0.0, 1.0);
    glVertex2f(512, 0);
  glEnd();

  GenEffect;
  DrawEffect;
  //MainDraw;

  glColor3f(1.0, 1.0, 1.0);
  glWrite(530, 450, PChar('         ' + IntToStr(score)));
  glWrite(530, 350, PChar('   ' + IntToStr(lives)));
  glWrite(530, 250, PChar(' .  ' + IntToStr(levelnum)));
  if win then
    glWrite(100, 250, ' ');
  if lose then
    glWrite(200, 250, '!');
end;

{------------------------------------------------------------------}
{                                            }
{------------------------------------------------------------------}
procedure glDraw;
begin
  glClear(GL_COLOR_BUFFER_BIT);
  glLoadIdentity();
  case c of
    10: MainGame;     //  
    20: InputRecords; //  
    30: MainRecords;  // 
  end;
end;

{------------------------------------------------------------------}
{                                           }
{------------------------------------------------------------------}
procedure InitEffectTex;
var
  temptex: pByteArray;
  i: Integer;
begin
  GetMem(temptex, wtex * wtex * 3);
  for i := 0 to wtex * wtex * 3 - 1 do
  begin
    temptex[i] := 0;
  end;
  glEnable(GL_TEXTURE_2D);
  glGenTextures(1, @EffectTex);
  glBindTexture(GL_TEXTURE_2D, EffectTex);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, wtex, wtex, 0, GL_RGB, GL_UNSIGNED_BYTE, temptex);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  FreeMem(temptex, wtex * wtex * 3);
  glDisable(GL_TEXTURE_2D);
end;

procedure glInit;
begin
  glClearColor(0.5, 0.5, 1.0, 0.0);
  glShadeModel(GL_SMOOTH);                 // Enables Smooth Color Shading

  BuildFont;

  InitEffectTex;

  glMatrixMode(GL_PROJECTION);  // Switch to the projection matrix
  glLoadIdentity();
  glOrtho(0, 768, 0, 512, -1, 1);  // Change the projection matrix using an orthgraphic projection
  glMatrixMode(GL_MODELVIEW);  // Return to the modelview matrix
  glLoadIdentity();

  glBlendFunc(GL_DST_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  LoadConfig('Data\cfg.txt');
end;


{------------------------------------------------------------------}
{  Handle window resize                                            }
{------------------------------------------------------------------}
procedure glResizeWnd(Width, Height : Integer);
begin
  if (Height = 0) then                // prevent divide by zero exception
    Height := 1;
  glViewport(0, 0, Width, Height);    // Set the viewport for the OpenGL window
  glMatrixMode(GL_PROJECTION);        // Change Matrix Mode to Projection
  glLoadIdentity();                   // Reset View
    gluPerspective(60.0, Width / Height, 0.1, 30.0);

  glMatrixMode(GL_MODELVIEW);         // Return to the modelview matrix
  glLoadIdentity();                   // Reset View

end;

{------------------------------------------------------------------}
{  Processes all the keystrokes                                    }
{------------------------------------------------------------------}
procedure ProcessKeys;
var
  tmp: GLfloat;
  i: byte;
begin
if not(paused) then
begin
  // Shoot
  if ((keys[VK_UP]) or (keys[Byte('W')]) or ((mbuttons and MK_LBUTTON) = 1)) and (zader = 0) then
  begin
    NewShoot;
    zader := 5;
  end;
  // MouseShift
  tmp := mchan.X;
  if abs(tmp) > 5 then
    tmp := 5 * abs(tmp) / tmp;
  if (keys[VK_RIGHT]) or (keys[Byte('D')]) or (tmp > 0) then
  begin
    if x < maxx then
      x := x + 5;
    if x > maxx then
      x := maxx;
  end;
  if (keys[VK_LEFT]) or (keys[Byte('A')]) or (tmp < 0) then
  begin
    if x > minx then
      x := x - 5;
    if x < minx then
      x := minx;
  end;
end;
  //  
  if c = 20 then
  begin
    if keys[VK_RETURN] and (sRecord <> '') then
    begin
      NewRecord;
      exit;
    end;
    if keys[VK_BACK] and (sRecord <> '') then
    begin
      keys[VK_BACK] := false;
      sRecord := Copy(sRecord, 1, length(sRecord) - 1);
    end;
    if length(sRecord) < 20 then
    begin
      for i := $41 to $5A do
      begin
        if keys[i] then
        begin
          keys[i] := false;
          sRecord := sRecord + Char(i);
        end;
      end;
    end;
  end;
  //  
  if keys[VK_ESCAPE] then
  begin
    if c = 10 then
    begin
      keys[VK_ESCAPE] := False;
      NewRecord;
      exit;
    end;
  end;
  // 
  if (keys[Byte('P')]) and (c = 10) then
  begin
    if not(win or lose) then
    begin
      keys[Byte('P')] := false;
      paused := not(paused);
    end;
  end;
end;


{------------------------------------------------------------------}
{  Determines the applications response to the messages received  }
{------------------------------------------------------------------}
function WndProc(hWnd: HWND; Msg: UINT;  wParam: WPARAM;  lParam: LPARAM): LRESULT; stdcall;
begin
  case (Msg) of
    WM_CREATE:
      begin
        // Insert stuff you want executed when the program starts
      end;
    WM_CLOSE:
      begin
        PostQuitMessage(0);
        Result := 0
      end;
    WM_KEYDOWN:       // Set the pressed key (wparam) to equal true so we can check if its pressed
      begin
        keys[wParam] := True;
        Result := 0;
      end;
    WM_KEYUP:         // Set the released key (wparam) to equal false so we can check if its pressed
      begin
        keys[wParam] := False;
        Result := 0;
      end;
    WM_LBUTTONDOWN:   //    
      begin
        mbuttons := wParam;
        Result := 0;
      end;
    WM_LBUTTONUP:     //    
      begin
        mbuttons := wParam;
        Result := 0;
      end;
    WM_SIZE:          // Resize the window with the new width and height
      begin
        glResizeWnd(LOWORD(lParam),HIWORD(lParam));
        Result := 0;
      end;
    WM_TIMER :                     // Add code here for all timers to be used.
      begin
        if wParam = FPS_TIMER then
        begin
          FPSCount :=Round(FPSCount * 1000/FPS_INTERVAL);   // calculate to get per Second incase intercal is less or greater than 1 second
          SetWindowText(h_Wnd, PChar(WND_TITLE + '     (' + intToStr(FPSCount) + ')'));
          FPSCount := 0;
          Result := 0;
        end;
        if wParam = GAME_TIMER then
        begin
          FromTimer;
          Result := 0;
        end;
      end;
    else
      Result := DefWindowProc(hWnd, Msg, wParam, lParam);    // Default result if nothing happens
  end;
end;


{---------------------------------------------------------------------}
{  Properly destroys the window created at startup (no memory leaks)  }
{---------------------------------------------------------------------}
procedure glKillWnd(Fullscreen : Boolean);
begin
  if Fullscreen then             // Change back to non fullscreen
  begin
    ChangeDisplaySettings(devmode(nil^), 0);
    ShowCursor(True);
  end;

ShowCursor(True);

  // Makes current rendering context not current, and releases the device
  // context that is used by the rendering context.
  if (not wglMakeCurrent(h_DC, 0)) then
    MessageBox(0, 'Release of DC and RC failed!', 'Error', MB_OK or MB_ICONERROR);

  // Attempts to delete the rendering context
  if (not wglDeleteContext(h_RC)) then
  begin
    MessageBox(0, 'Release of rendering context failed!', 'Error', MB_OK or MB_ICONERROR);
    h_RC := 0;
  end;

  // Attemps to release the device context
  if ((h_DC = 1) and (ReleaseDC(h_Wnd, h_DC) <> 0)) then
  begin
    MessageBox(0, 'Release of device context failed!', 'Error', MB_OK or MB_ICONERROR);
    h_DC := 0;
  end;

  // Attempts to destroy the window
  if ((h_Wnd <> 0) and (not DestroyWindow(h_Wnd))) then
  begin
    MessageBox(0, 'Unable to destroy window!', 'Error', MB_OK or MB_ICONERROR);
    h_Wnd := 0;
  end;

  // Attempts to unregister the window class
  if (not UnRegisterClass('OpenGL', hInstance)) then
  begin
    MessageBox(0, 'Unable to unregister window class!', 'Error', MB_OK or MB_ICONERROR);
    hInstance := 0;
  end;
end;


{--------------------------------------------------------------------}
{  Creates the window and attaches a OpenGL rendering context to it  }
{--------------------------------------------------------------------}
function glCreateWnd(Width, Height : Integer; Fullscreen : Boolean; PixelDepth : Integer) : Boolean;
var
  wndClass : TWndClass;         // Window class
  dwStyle : DWORD;              // Window styles
  dwExStyle : DWORD;            // Extended window styles
  dmScreenSettings : DEVMODE;   // Screen settings (fullscreen, etc...)
  PixelFormat : GLuint;         // Settings for the OpenGL rendering
  h_Instance : HINST;           // Current instance
  pfd : TPIXELFORMATDESCRIPTOR;  // Settings for the OpenGL window
begin

ShowCursor(false);

  h_Instance := GetModuleHandle(nil);       //Grab An Instance For Our Window
  ZeroMemory(@wndClass, SizeOf(wndClass));  // Clear the window class structure

  with wndClass do                    // Set up the window class
  begin
    style         := CS_HREDRAW or    // Redraws entire window if length changes
                     CS_VREDRAW or    // Redraws entire window if height changes
                     CS_OWNDC;        // Unique device context for the window
    lpfnWndProc   := @WndProc;        // Set the window procedure to our func WndProc
    hInstance     := h_Instance;
    hCursor       := LoadCursor(0, IDC_ARROW);
    lpszClassName := 'OpenGL';
  end;

  if (RegisterClass(wndClass) = 0) then  // Attemp to register the window class
  begin
    MessageBox(0, 'Failed to register the window class!', 'Error', MB_OK or MB_ICONERROR);
    Result := False;
    Exit
  end;

  // Change to fullscreen if so desired
  if Fullscreen then
  begin
    ZeroMemory(@dmScreenSettings, SizeOf(dmScreenSettings));
    with dmScreenSettings do begin              // Set parameters for the screen setting
      dmSize       := SizeOf(dmScreenSettings);
      dmPelsWidth  := Width;                    // Window width
      dmPelsHeight := Height;                   // Window height
      dmBitsPerPel := PixelDepth;               // Window color depth
      dmFields     := DM_PELSWIDTH or DM_PELSHEIGHT or DM_BITSPERPEL;
    end;

    // Try to change screen mode to fullscreen
    if (ChangeDisplaySettings(dmScreenSettings, CDS_FULLSCREEN) = DISP_CHANGE_FAILED) then
    begin
      MessageBox(0, 'Unable to switch to fullscreen!', 'Error', MB_OK or MB_ICONERROR);
      Fullscreen := False;
    end;
  end;

  // If we are still in fullscreen then
  if (Fullscreen) then
  begin
    dwStyle := WS_POPUP or                // Creates a popup window
               WS_CLIPCHILDREN            // Doesn't draw within child windows
               or WS_CLIPSIBLINGS;        // Doesn't draw within sibling windows
    dwExStyle := WS_EX_APPWINDOW;         // Top level window
    ShowCursor(False);                    // Turn of the cursor (gets in the way)
  end
  else
  begin
    dwStyle := WS_OVERLAPPEDWINDOW or     // Creates an overlapping window
               WS_CLIPCHILDREN or         // Doesn't draw within child windows
               WS_CLIPSIBLINGS;           // Doesn't draw within sibling windows
    dwExStyle := WS_EX_APPWINDOW or       // Top level window
                 WS_EX_WINDOWEDGE;        // Border with a raised edge
  end;

  // Attempt to create the actual window
  h_Wnd := CreateWindowEx(dwExStyle,      // Extended window styles
                          'OpenGL',       // Class name
                          WND_TITLE,      // Window title (caption)
                          dwStyle,        // Window styles
                          0, 0,           // Window position
                          Width, Height,  // Size of window
                          0,              // No parent window
                          0,              // No menu
                          h_Instance,     // Instance
                          nil);           // Pass nothing to WM_CREATE
  if h_Wnd = 0 then
  begin
    glKillWnd(Fullscreen);                // Undo all the settings we've changed
    MessageBox(0, 'Unable to create window!', 'Error', MB_OK or MB_ICONERROR);
    Result := False;
    Exit;
  end;

  // Try to get a device context
  h_DC := GetDC(h_Wnd);
  if (h_DC = 0) then
  begin
    glKillWnd(Fullscreen);
    MessageBox(0, 'Unable to get a device context!', 'Error', MB_OK or MB_ICONERROR);
    Result := False;
    Exit;
  end;

  // Settings for the OpenGL window
  with pfd do
  begin
    nSize           := SizeOf(TPIXELFORMATDESCRIPTOR); // Size Of This Pixel Format Descriptor
    nVersion        := 1;                    // The version of this data structure
    dwFlags         := PFD_DRAW_TO_WINDOW    // Buffer supports drawing to window
                       or PFD_SUPPORT_OPENGL // Buffer supports OpenGL drawing
                       or PFD_DOUBLEBUFFER;  // Supports double buffering
    iPixelType      := PFD_TYPE_RGBA;        // RGBA color format
    cColorBits      := PixelDepth;           // OpenGL color depth
    cRedBits        := 0;                    // Number of red bitplanes
    cRedShift       := 0;                    // Shift count for red bitplanes
    cGreenBits      := 0;                    // Number of green bitplanes
    cGreenShift     := 0;                    // Shift count for green bitplanes
    cBlueBits       := 0;                    // Number of blue bitplanes
    cBlueShift      := 0;                    // Shift count for blue bitplanes
    cAlphaBits      := 0;                    // Not supported
    cAlphaShift     := 0;                    // Not supported
    cAccumBits      := 0;                    // No accumulation buffer
    cAccumRedBits   := 0;                    // Number of red bits in a-buffer
    cAccumGreenBits := 0;                    // Number of green bits in a-buffer
    cAccumBlueBits  := 0;                    // Number of blue bits in a-buffer
    cAccumAlphaBits := 0;                    // Number of alpha bits in a-buffer
    cDepthBits      := 16;                   // Specifies the depth of the depth buffer
    cStencilBits    := 0;                    // Turn off stencil buffer
    cAuxBuffers     := 0;                    // Not supported
    iLayerType      := PFD_MAIN_PLANE;       // Ignored
    bReserved       := 0;                    // Number of overlay and underlay planes
    dwLayerMask     := 0;                    // Ignored
    dwVisibleMask   := 0;                    // Transparent color of underlay plane
    dwDamageMask    := 0;                     // Ignored
  end;

  // Attempts to find the pixel format supported by a device context that is the best match to a given pixel format specification.
  PixelFormat := ChoosePixelFormat(h_DC, @pfd);
  if (PixelFormat = 0) then
  begin
    glKillWnd(Fullscreen);
    MessageBox(0, 'Unable to find a suitable pixel format', 'Error', MB_OK or MB_ICONERROR);
    Result := False;
    Exit;
  end;

  // Sets the specified device context's pixel format to the format specified by the PixelFormat.
  if (not SetPixelFormat(h_DC, PixelFormat, @pfd)) then
  begin
    glKillWnd(Fullscreen);
    MessageBox(0, 'Unable to set the pixel format', 'Error', MB_OK or MB_ICONERROR);
    Result := False;
    Exit;
  end;

  // Create a OpenGL rendering context
  h_RC := wglCreateContext(h_DC);
  if (h_RC = 0) then
  begin
    glKillWnd(Fullscreen);
    MessageBox(0, 'Unable to create an OpenGL rendering context', 'Error', MB_OK or MB_ICONERROR);
    Result := False;
    Exit;
  end;

  // Makes the specified OpenGL rendering context the calling thread's current rendering context
  if (not wglMakeCurrent(h_DC, h_RC)) then
  begin
    glKillWnd(Fullscreen);
    MessageBox(0, 'Unable to activate OpenGL rendering context', 'Error', MB_OK or MB_ICONERROR);
    Result := False;
    Exit;
  end;

  // Initializes the timer used to calculate the FPS
  SetTimer(h_Wnd, FPS_TIMER, FPS_INTERVAL, nil);
  SetTimer(h_Wnd, GAME_TIMER, GAME_INTERVAL, nil);

  // Settings to ensure that the window is the topmost window
  ShowWindow(h_Wnd, SW_SHOW);
  SetForegroundWindow(h_Wnd);
  SetFocus(h_Wnd);

  // Ensure the OpenGL window is resized properly
  glResizeWnd(Width, Height);
  glInit();

  Result := True;
end;


{--------------------------------------------------------------------}
{  Main message loop for the application                             }
{--------------------------------------------------------------------}
function WinMain(hInstance : HINST; hPrevInstance : HINST;
                 lpCmdLine : PChar; nCmdShow : Integer) : Integer; stdcall;
var
  msg : TMsg;
  finished : Boolean;
  DemoStart, LastTime : DWord;
begin
  finished := False;

  // Perform application initialization:
  if not glCreateWnd(screenWidth, screenHeight, false, 32) then
  begin
    Result := 0;
    Exit;
  end;

  DemoStart := GetTickCount();            // Get Time when demo started

  // Main message loop:
  while not finished do
  begin
    if (PeekMessage(msg, 0, 0, 0, PM_REMOVE)) then // Check if there is a message for this window
    begin
      if (msg.message = WM_QUIT) then     // If WM_QUIT message received then we are done
        finished := True
      else
      begin                               // Else translate and dispatch the message to this window
  	TranslateMessage(msg);
        DispatchMessage(msg);
      end;
    end
    else
    begin
      Inc(FPSCount);                      // Increment FPS Counter

      LastTime :=ElapsedTime;
      ElapsedTime :=GetTickCount() - DemoStart;     // Calculate Elapsed Time
      ElapsedTime :=(LastTime + ElapsedTime) DIV 2; // Average it out for smoother movement

      GetCursorPos(mpos);
      mchan.X := mpos.X - trunc(screenWidth/2);
      mchan.Y := mpos.Y - trunc(screenHeight/2);
      SetCursorPos(trunc(screenWidth/2), trunc(screenHeight/2));

      glDraw();                           // Draw the scene
      SwapBuffers(h_DC);                  // Display the scene

      if (keys[VK_ESCAPE]) and (c <> 10) then           // If user pressed ESC then set finised TRUE
        finished := True
      else
        ProcessKeys;                      // Check for any other key Pressed
    end;
  end;
  glKillWnd(FALSE);
  Result := msg.wParam;
end;


begin
  WinMain( hInstance, hPrevInst, CmdLine, CmdShow );
end.
