unit _render;

interface

uses _var, _scd, _draw, exgine, openGL, SysUtils;

procedure render_menu;
procedure render_intro_ALTA;
procedure render_intro_logo;
procedure render_intro_text;
procedure render_intro_scroll;
procedure render_game;

implementation

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure render_stars;
var a:integer;
begin
glBegin(GL_POINTS);
    for a:=0 to high(starsky[0]) do
        begin
          glColor3f(starsky[2,a],starsky[2,a],starsky[2,a]);
          glVertex3d(starsky[0,a],starsky[1,a],0);
      end;
glEnd();
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure render_menu;
var s:string;
begin
render_stars;
glColor3ub(236,199,96);
ogl.Blend(BT_ADD);
draw(t[swlogo],400,150,256,128,0);
ogl.Blend(BT_SUB);

s:='HIGH SCORE';
ogl.TextOut(fnt12,400-ogl.TextLen(fnt12,pchar(s))/2,250,pchar(s));
s:=inttostr(player.hiscore);
ogl.TextOut(fnt16,400-ogl.TextLen(fnt16,pchar(s))/2,270,pchar(s));


draw(t[enter],360-10,359,32,32,0);
ogl.TextOut(fnt12,370,350,pchar('Start game'));

s:='(C) Alexandr "Shirson" Nevskiy 2008';
ogl.TextOut(fnt8,400-ogl.TextLen(fnt8,pchar(s))/2,580,pchar(s));

draw(t[esc],360-10,409,32,32,0);
ogl.TextOut(fnt12,370,400,pchar('Exit game'));

glColor3ub(118,100,48);
s:='    ,       SW Synth ';
ogl.TextOut(fnt8,400-ogl.TextLen(fnt8,pchar(s))/2,500,pchar(s));
s:='If you do not hear music, close game and check SW Synth volume control';
ogl.TextOut(fnt8,400-ogl.TextLen(fnt8,pchar(s))/2,516,pchar(s));

end;


//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure render_intro_ALTA;
begin
glColor3ub(trunc(51*introfade/255), trunc(204*introfade/255), trunc(255*introfade/255));
ogl.TextOut(fntL, 200, 220, pchar('A long time ago, in a galaxy far,'));
ogl.TextOut(fntL, 200, 260, pchar('far away....'));
end;


//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure render_intro_logo;
begin
render_stars;
glColor3ub(236,199,96);
ogl.Blend(BT_ADD);
draw(t[swlogo],400,{introfade/4-256+}300,introfade,introfade/2,0);
ogl.Blend(BT_SUB);
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure render_intro_text;
begin
render_stars;
ogl.Set3D(45, 0.1, 4096);
glEnable(GL_DEPTH_TEST);
glTranslatef(0, 0, -500);
glColor3ub(trunc(dbl*236),trunc(dbl*199),trunc(dbl*96));
drawtxt(t[swtext],0,0,introfade,256,1024,0);
//ogl.Set2D(0, 0, 800, 600);

end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure render_intro_scroll;
begin
  glDisable(GL_DEPTH_TEST);
  render_stars;
  if introfade>200 then
    begin
      glColor3ub(255,255,255);
      //if trunc(introfade) mod 80 in [40..79] then
      ogl.TextOut(fnt16, 320,250, pchar('GET READY'));
    end;
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure render_game;
var a,b:integer;
    s:string;
begin
//  ogl.Set2D(0, 0, 800, 600);

if high(a_score)>=0 then
  for a:=0 to high(a_score) do
  begin
    glColor3ub(trunc(141/255*a_score[a].frame), trunc(207/255*a_score[a].frame), trunc(244/255*a_score[a].frame));
    ogl.TextOut(fnt8, a_score[a].x, a_score[a].y, pchar(a_score[a].value+' '));
  end;

render_stars;

gldisable(GL_ALPHA_TEST);
ogl.Blend(BT_SUB);
glColor3ub(255,255,255);
draw(t[xwing],player.x,player.y,48,48,0);


if high(a_enemy)>=0 then
begin
  for a:=0 to high(a_enemy) do
    begin
    b:=trunc(a_enemy[a].frame);
    if b<0 then b:=18+b;
     if a_enemy[a].order=200 then glColor3ub(196,196,196) else glColor3ub(255,255,255); //glColor3ub(a_enemy[a].color,a_enemy[a].color,a_enemy[a].color);
    draw(t[tief+a_enemy[a].bif*18+b],a_enemy[a].x,a_enemy[a].y,32,32,a_enemy[a].angle);
    if (a_enemy[a].order=200) and (random(10)=0) then
      begin
        ogl.Blend(BT_ADD);
        glColor3ub(41,207,255);
        draw(t[spark+random(8)],a_enemy[a].x,a_enemy[a].y,32,32,a_enemy[a].angle);
      end;
    end;
  glColor3ub(255,255,255);
  s:=' STAGE '+inttostr(player.Stage+1)+' ';
  if a_enemy[0].delay>0 then ogl.TextOut(fnt16, 400-ogl.TextLen(fnt16,pchar(s))/2,150, pchar(s));
end;

glColor3ub(237,126,137);
ogl.Blend(BT_ADD);
draw(t[exh1],player.x,player.y+26,21+random(6),26,0);

if high(a_shots_ally)>=0 then
  for a:=0 to high(a_shots_ally) do
    begin
      glColor3ub(255,120,130);
      draw(t[shot1],a_shots_ally[a].x, a_shots_ally[a].y, 4, 32, a_shots_ally[a].angle);
    end;


if high(a_bonus)>=0 then
  for a:=0 to high(a_bonus) do
    begin
      ogl.Blend(BT_ADD);
      glColor3ub(255,255,255);
      case a_bonus[a].value[1] of
      '0':  begin
             draw(t[lives],a_bonus[a].x, a_bonus[a].y, 32, 32,0);
              s:='+1 Life ';
              glColor3ub(0,196,0);
            end;
      '1':  begin
              draw(t[rpm],a_bonus[a].x, a_bonus[a].y, 32, 32,0);
              s:='Rapid fire';
              glColor3ub(220,0,0);
            end;
      '2':  begin
              draw(t[multishot],a_bonus[a].x, a_bonus[a].y, 32, 32,0);
              s:='Multishot';
              glColor3ub(0,0,255);
            end;
      end;
      ogl.TextOut(fnt8, a_bonus[a].x-ogl.TextLen(fnt8,pchar(s))/2,a_bonus[a].y-36, pchar(s));
    end;

ogl.Blend(BT_ADD);
if high(a_shots_enemy)>=0 then
  for a:=0 to high(a_shots_enemy) do
    begin
      if a_shots_enemy[a].tp=0 then
        begin
          glColor3ub(120,255,137);
          draw(t[shot1],a_shots_enemy[a].x, a_shots_enemy[a].y, 4, 32, a_shots_enemy[a].angle);
        end;
      if a_shots_enemy[a].tp=1 then
        begin
          if a_shots_enemy[a].count mod 20 in [1..2] then b:=24 else b:=8;
          glColor3ub(140,200,255);
          draw(t[bomb],a_shots_enemy[a].x, a_shots_enemy[a].y, b, b, a_shots_enemy[a].angle);
        end;
    end;

glColor3ub(255,255,255);
if high(a_explosions)>=0 then
  for a:=0 to high(a_explosions) do
     draw(t[a_explosions[a].frame+expl+a_explosions[a].tp],a_explosions[a].x, a_explosions[a].y-4, a_explosions[a].size, a_explosions[a].size, a_explosions[a].angle);

s:=inttostr(Player.counting);
ogl.TextOut(fnt10, 700-ogl.TextLen(fnt10,pchar(s)), 8, pchar(s));
ogl.TextOut(fnt10, 710, 8, pchar('Score'));
s:=inttostr(player.stage+1);
ogl.TextOut(fnt10, 500-ogl.TextLen(fnt10,pchar(s)), 8, pchar(s));
ogl.TextOut(fnt10, 510, 8, pchar('Stage'));
s:=inttostr(Player.Lives);
ogl.TextOut(fnt10, 300-ogl.TextLen(fnt10,pchar(s)), 8, pchar(s));
ogl.TextOut(fnt10, 310, 8, pchar('Lives'));

case Player.RPM of
50: s:='x1';
40: s:='x2';
30: s:='x3';
20: s:='Max';
end;
ogl.TextOut(fnt10, 100-ogl.TextLen(fnt10,pchar(s)), 8, pchar(s));
ogl.TextOut(fnt10, 110, 8, pchar('Firing rate'));


s:='PAUSE';
if pause then ogl.TextOut(fnt16, 400-ogl.TextLen(fnt16,pchar(s))/2,250, pchar(s));

s:='GAME OVER';
  if player.Lives=0 then ogl.TextOut(fnt16, 400-ogl.TextLen(fnt16,pchar(s))/2,150, pchar(s));

end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

end.



