unit uOptions;

interface
uses
  zglHeader;

procedure options_Load;
procedure options_Set;

var
  oWidth      : Integer = 800;
  oHeight     : Integer = 600;
  oRefresh    : Integer = REFRESH_MAXIMUM;
  oFullScreen : Integer = 0;
  oWaitVSync  : Integer = 0;
  oAnisotropy : Integer = 0;
//  oAA         : Integer = 0;
  oHeightMap  : Integer = 1;

implementation

procedure options_Load;
begin
  ini_LoadFromFile( 'settings.ini' );
  oWidth := ini_ReadKeyInt( 'Screen', 'Width' );
  oHeight := ini_ReadKeyInt( 'Screen', 'Height' );
  oRefresh := ini_ReadKeyInt( 'Screen', 'Refresh' );
  oFullScreen := ini_ReadKeyInt( 'Screen', 'FullScreen' );
  oWaitVsync := ini_ReadKeyInt( 'Screen', 'VSync' );
//  oAA := ini_ReadKeyInt( 'Screen', 'AA' );
  oAnisotropy := ini_ReadKeyInt( 'Screen', 'Anisotropy' );
  oHeightMap := ini_ReadKeyInt( 'Screen', 'HeightMapQuality' );
end;

procedure options_Set;
begin
  scr_SetOptions( oWidth, oHeight, 32, oRefresh, Boolean( oFullScreen ), Boolean( oWaitVSync ) );
end;

end.
