unit uBonuses;

interface
uses
  zglHeader;

const
  MAX_BONUSES = 10;

  bst_Weapon = 0;

type
  TBonus = record
    _type  : Byte;
    Col    : zglTSphere;
    Angle  : Single;
    Matrix : zglTMatrix4f;
end;

procedure bonuses_Add( aType : Byte; aX, aY, aZ : Single );
procedure bonuses_Del( i : Integer );
procedure bonuses_Draw;
procedure bonuses_Proc;

var
  bonuses : array[ 0..MAX_BONUSES - 1 ] of TBonus;
  bsCount : Integer = 0;

implementation
uses
  uMain, uPlayer, uWeapon, uRes;

procedure bonuses_Add;
begin
  with bonuses[ bsCount ] do
    begin
      _type          := aType;
      Col.Position.X := aX;
      Col.Position.Y := aY;
      Col.Position.Z := aZ;
      Col.Radius     := 0.3;
    end;

  INC( bsCount );
end;

procedure bonuses_Del;
begin
  bonuses[ i ] := bonuses[ bsCount - 1 ];
  DEC( bsCount );
end;

procedure bonuses_Draw;
  var
    i : Integer;
begin
  for i := 0 to bsCount - 1 do
    with bonuses[ i ] do
      begin
        if not frustum_SphereIn( @frustum, Col.Position.X, Col.Position.Y, Col.Position.Z, Col.Radius ) Then continue;
        obj3d_Begin( OBJ3D_TEXTURING or OBJ3D_CULL_FACE );
          obj3d_MulMatrix( @Matrix );

          obj3d_BindTexture( tex_bonus[ _type ], 0 );
          smesh_Draw( sm_bonus[ _type ] );

          if debug Then
            begin
              obj3d_Disable( OBJ3D_TEXTURING );
              obj3d_Enable( OBJ3D_WIRE_FRAME );
              pr3d_Sphere( Col.Radius, 32 );
              obj3d_Disable( OBJ3D_WIRE_FRAME );
            end;
        obj3d_End;
      end;
end;

procedure bonuses_Proc;
  var
    i : Integer;
begin
  i := 0;
  while i < bsCount do
    with bonuses[ i ] do
      begin
        Angle := Angle + 1;
        matrix4f_Translate( @Matrix, Col.Position.X, Col.Position.Y, Col.Position.Z );
        matrix4f_Rotate( @Matrix, 0, Angle * cv_pi180, 0 );

        if col3d_AABBVsSphere( @Player.Col, @Col ) Then
          begin
            weapon_Init( Player.Weapon, Player.Weapon._type + 1, TRUE );
            bonuses_Del( i );
            continue;
          end;
        if Col.Position.Z - Col.Radius > Camera.Position.Z Then
          begin
            bonuses_Del( i );
            continue;
          end;
        INC( i );
      end;
end;

end.
