///////////////////////////////////////////////////////////
////////      Hud&Gui Fast Editor   /////////
////////     OMEGA engine                      /////////
////////  www.cdmlex.by.ru 2008                   /////////
////////  cdmlex ( )               /////////
////////   v1.0 15.08.08                    /////////
///////////////////////////////////////////////////////////

unit gh_OMEGA;
interface
uses
  LexUTILS, OMEGA, Setup;

const
  No_Mouse = 1;
  Mouse_In = 2;
  Mouse_Cl = 3;
  disabled = 4;

type
//  
  TGHColor = array[1..3] of integer;

  TGHDV = (colored, easyscin, scin);

  TGHType = (tForm, tLabel, tButton, tAButton, tCheckBox, tImage );

  GHRect = record
    X, Y : integer;
    W, H : word;
  end;

  TGHRazmetka = record
    FX,FY : array[1..3] of integer;
    SH, SW  : word;
    MX, MY, TCHX, TCHY : integer;
  end;

  TGHCapt = record
    Sz : real;
    Ft, Col : integer;
    LD : ghRect;
    Tx : string;
  end;

  TGHStandart = record
    V : boolean;     {Enabled} {Visible}
    D : ghRect;         {Draw}
    N : String;   {Name} {Skin Name}
    L, F, SI, ID : shortint; {Layer} {Form} {Skin Number} {Alpha} {Razmetka}
    A : byte;
    GHDV : TGHDV;
    GHType : TGHType;
  end;

// 
  TGHScin = record
    T : OMEGA.PTexture;
    S : String;
  end;
//  
  TGHLabel = record
    GHCapt : TGHCapt;
    N : string;
  end;

  TGHButton = record
    S : TGHStandart;
    Capt : TGHCapt;
    M : byte;
    R : integer;
  end;

  TGHAButton = record
    S : TGHStandart;
    Capt : TGHCapt;
    A, M : byte;  { , }
  end;

  TGHCheckBox = record
    S : TGHStandart;
    Capt : TGHCapt;
    Checked : Boolean;
    M : byte;
  end;

  TGHImage = record
    S : TGHStandart;
    Angle : real;
  end;

//  
  TGHObjects = record
    GHLabel : array of TGHLabel;
    GHButton : array of TGHButton;
    GHAButton : array of TGHAButton;
    GHCheckBox : array of TGHCheckBox;
    GHImage : array of TGHImage;
  end;
// 
  TGHForm = record
    S : TGHStandart;
    Capt : TGHCapt;
    GHObj : TGHObjects;
    SHH : word;
    R : integer;
  end;

// C
  TGHLayer = record
    Name : String;
    E, V : boolean; {Enabled} {Visible}
    GHForm : array of TGHForm;
    GHObj  : TGHObjects;
  end;

  Procedure Test;
  Procedure CreatGHLayer;
  Procedure DrawGHObj(GH : TGHobjects);
  Procedure DrawGH;
  Procedure CreatGHFont(FN : string);
  Procedure CreatGHScin(FN : string; W,H : byte);
  Procedure CreatGHObj(S : TGHStandart; C : TGHCapt);
  Procedure CreatGHColor(A1,B1,C1 : integer);
  
var
  GHLayer : array of TGHLayer;
  GHScin  : array of TGHScin;
  GHFont : array of PFont2D;
  GHR : array of TGHRazmetka;
  GHColor : array of TGHColor;
  ChoisedOBJ : TGHStandart;
  UsedLayer : integer= -1;

implementation


Procedure CreatGHLayer;
begin
  SetLength(GHLayer, length(GHLayer)+1);
  with GHLayer[length(GHLayer)-1] do
   begin
    Name:='GHLayer' + Int2S(length(GHLayer));
    E:=true;
    V:=true;
   end;
end;

Function AddGHR : integer;
begin
  SetLength(GHR, length(GHR)+1);
  result:=length(GHR)-1;
end;

Function SetCapt(S : TGHStandart; Capt : TGHCapt) : TGHCapt;
begin
  Capt.LD.W:=round(Text_GetWidth(GHFont[Capt.Ft], PChar(Capt.Tx), Capt.Sz));
  Capt.LD.H:=round(GHFont[Capt.Ft].Height*Capt.Sz);
  Capt.LD.X:=(S.D.X + (S.D.W - Capt.LD.W) div 2);
  Capt.LD.Y:=(S.D.Y + (S.D.H  - Capt.LD.H) div 2);
  result:=Capt;
end;

Procedure SetGHFormS(I, J : integer);
begin
  with GHLayer[I].GHForm[I] do
    begin
      if (Capt.Ft<=length(GHFont)-1) and (length(GHFont)>0) then
      SHH:=round(GHFont[Capt.Ft].Height*Capt.Sz) + 10;
      if S.GHDV=scin then
      begin
        if R<0 then R:=AddGHR;
        with GHR[R] do
         begin
           SW:=GHScin[S.SI].T.Width div 4;
           SH:=GHScin[S.SI].T.Height div 4;
           if 1.5*SW>S.D.W then
            SW:=round(S.D.W / 4);
           if 1.5*SH>S.D.H then
            SH:=round(S.D.H / 4);
           if SHH<SH then
           SHH:=SH;
           FX[1]:=round(S.D.X) + SW;
           FX[3]:=round(S.D.X) + round(S.D.W) -SW;
           TCHX:=round(FX[3]-FX[1]-SW) div SW;
           FX[2]:=FX[1] + TCHX*SW;
           MX:=FX[3]-FX[2];
           FY[1]:=round(S.D.Y) + SHH;
           FY[3]:=round(S.D.Y) + round(S.D.H) -SH;
           TCHY:=round(FY[3]-FY[1]-SH) div SH;
           FY[2]:=FY[1] + TCHY*SH;
           MY:=FY[3]-FY[2];
         end;
       end;
    end;
end;

Procedure CreatGHImage(SS : TGHStandart; var GHObj : TGHObjects);
var
 I : integer;
begin
  with GHObj do
   begin
     I:=length(GHImage);
     SetLength(GHImage, I+1);
     GHImage[I].S:=SS;
     GHImage[I].S.N:=SS.N + Int2S(I);
   end;
end;

Procedure CreatGHForm(SS : TGHStandart; SCapt : TGHCapt);
var
 I : integer;
begin
  with GHLayer[SS.L] do
   begin
     I:=length(GHForm);
     SetLength(GHForm, I+1);
     with GHForm[I] do
      begin
        S:=SS;
        Capt:=SCapt;
        S.ID:=I;
        R:=-1;
        SetGHFormS(SS.L,I);
        SS.D.H:=SHH;
        Capt:=SetCapt(SS, Capt);
        inc(Capt.LD.Y, 4);
        S.N:=SS.N + Int2S(I);
      end;
   end;
end;

Procedure CreatGHLabel(SS : TGHStandart; Capt : TGHCapt; var GHObj : TGHObjects);
var
  I : integer;
begin
  with GHObj do
   begin
     I:=length(GHLabel);
     SetLength(GHLabel, I+1);
     GHLabel[I].GHCapt:=Capt;
     GHLabel[I].GHCapt:=SetCapt(SS,Capt);
//     GHLabel[I].GHCapt.LD.X:=SS.D.X;
     GHLabel[I].GHCapt.LD.Y:=SS.D.Y;
     GHLabel[I].N:=SS.N + Int2S(I);
   end;
end;

Function SetGHButtonS(S : TGHStandart; R : integer ) : integer;
begin
  if R<0 then R:=AddGHR;
  with GHR[R] do
   begin
     SW:=GHScin[S.SI].T.Width div 4;
     SH:=GHScin[S.SI].T.Height div 4;
     if 1.5*SW>S.D.W then
      SW:=round(S.D.W / 4);
     if 1.5*SH>S.D.H then
      SH:=round(S.D.H / 4);

     FX[1]:=round(S.D.X) + SW;
     FX[3]:=round(S.D.X) + round(S.D.W) -SW;
     TCHX:=round(FX[3]-FX[1]-SW) div SW;
     if TCHX<0 then TCHX:=0;
     FX[2]:=FX[1] + TCHX*SW;
     MX:=FX[3]-FX[2];
     if MX<0 then MX:=0;
     FY[1]:=round(S.D.Y) + SH;
     FY[3]:=round(S.D.Y) + round(S.D.H) -SH;
     TCHY:=round(FY[3]-FY[1]-SH) div SH;
     if TCHY<0 then TCHY:=0;
     FY[2]:=FY[1] + TCHY*SH;
     MY:=FY[3]-FY[2];
     if MY<0 then MY:=0;
   end;
   result:=R;
end;

Procedure CreatGHButton(SS : TGHStandart; GHCapt : TGHCapt; var GHObj : TGHObjects);
var
  I : integer;
begin
  with GHObj do
   begin
     I:=length(GHButton);
     SetLength(GHButton,I+1);
     GHButton[I].S:=SS;
     if SS.GHDV=scin then
     GHButton[I].R:=SetGHButtonS(SS, -1);
     GHButton[I].M:=1;
     GHButton[I].Capt:=SetCapt(SS,GHCapt);
     GHButton[I].S.N:=SS.N + Int2S(I);
   end;
end;

Procedure CreatGHAButton(SS : TGHStandart; GHCapt : TGHCapt; var GHObj : TGHObjects);
var
  I : integer;
begin
  with GHObj do
   begin
     I:=length(GHAButton);
     SetLength(GHAButton,I+1);
     GHAButton[I].S:=SS;
     GHAButton[I].M:=1;
     GHAButton[I].A:=0;
     GHAButton[I].Capt:=SetCapt(SS,GHCapt);
     GHAButton[I].S.N:=SS.N + Int2S(I);
   end;
end;

Procedure CreatGHCheckBox(SS : TGHStandart; GHCapt : TGHCapt; var GHObj : TGHObjects);
var
  I : integer;
begin
  with GHObj do
   begin
     I:=length(GHCheckBox);
     SetLength(GHCheckBox,I+1);
     GHCheckBox[I].S:=SS;
     GHCheckBox[I].M:=1;
     GHCheckBox[I].Capt:=SetCapt(SS,GHCapt);
     GHCheckBox[I].Capt.LD.X:=SS.D.X+ SS.D.W +5;
     GHCheckBox[I].Checked:=true;
     GHCheckBox[I].S.N:=SS.N + Int2S(I);
   end;
end;

Procedure CreatGHObj(S : TGHStandart; C : TGHCapt);
begin
  Case S.GHType of
   tForm :
     CreatGHForm(S, C);
   tImage :
     if S.F<0 then
     CreatGHImage(S, GHLayer[S.L].GHObj)
     else
     CreatGHImage(S, GHLayer[S.L].GHForm[S.F].GHObj);
   tLabel :
     if S.F<0 then
     CreatGHLabel(S, C, GHLayer[S.L].GHObj)
     else
     CreatGHLabel(S, C, GHLayer[S.L].GHForm[S.F].GHObj);
   tButton :
     if S.F<0 then
     CreatGHButton(S, C, GHLayer[S.L].GHObj)
     else
     CreatGHButton(S, C, GHLayer[S.L].GHForm[S.F].GHObj);
   tAButton:
     if S.F<0 then
     CreatGHAButton(S, C, GHLayer[S.L].GHObj)
     else
     CreatGHAButton(S, C, GHLayer[S.L].GHForm[S.F].GHObj);
   tCheckBox:
     if S.F<0 then
     CreatGHCheckBox(S, C, GHLayer[S.L].GHObj)
     else
     CreatGHCheckBox(S, C, GHLayer[S.L].GHForm[S.F].GHObj);
   end;
end;

/// 

Procedure DrawGHText(C : TGHCapt);
begin
  if C.Tx<>'' then
  Text_Draw( GHFont[C.Ft], C.LD.X, C.LD.Y, PChar( C.Tx), C.Sz, 0, 255, C.Col)
end;

Procedure DrawRObj(S : TGHStandart; R: integer; Flag:integer=1; SHH: integer=0);
begin
  with GHR[R] do
   begin
     if SHH=0 then
     SHH:=SH;
     Omega.ASprite_Draw (GHScin[S.SI].T, S.D.X, S.D.Y, SW, SHH, 1, S.A, 0, Flag);
     Omega.ATile_Draw   (GHScin[S.SI].T, FX[1], S.D.Y, SW, SHH, TCHX, 1, 2, S.A, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, FX[2], S.D.Y, MX, SHH, 3, S.A, 0, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, FX[3], S.D.Y, SW, SHH, 4, S.A, 0, Flag);
     Omega.ATile_Draw   (GHScin[S.SI].T, S.D.X, FY[1], SW, SH, 1,    TCHY, 5, S.A, Flag);
     Omega.ATile_Draw   (GHScin[S.SI].T, FX[1], FY[1], SW, SH, TCHX, TCHY, 6, S.A, Flag);
     Omega.ATile_Draw   (GHScin[S.SI].T, FX[2], FY[1], MX, SH, 1,    TCHY, 7, S.A, Flag);
     Omega.ATile_Draw   (GHScin[S.SI].T, FX[3], FY[1], SW, SH, 1,    TCHY, 8, S.A, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, S.D.X, FY[2], SW, MY, 9, S.A, 0, Flag);
     Omega.ATile_Draw   (GHScin[S.SI].T, FX[1], FY[2], SW, MY, TCHX, 1, 10, S.A, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, FX[2], FY[2], MX, MY, 11, S.A, 0, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, FX[3], FY[2], SW, MY, 12, S.A, 0, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, S.D.X, FY[3], SW, SH, 13, S.A, 0, Flag);
     Omega.ATile_Draw   (GHScin[S.SI].T, FX[1], FY[3], SW, SH, TCHX, 1, 14, S.A, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, FX[2], FY[3], MX, SH, 15, S.A, 0, Flag);
     Omega.ASprite_Draw (GHScin[S.SI].T, FX[3], FY[3], SW, SH, 16, S.A, 0, Flag);
  end;
end;

Function GetFL(M : integer) : integer;
begin
  if M>3 then
  FX_SetColorMix($00A8A297)
  else
  FX_SetColorMix(GHColor[0,M]);
  if GHColor[0,M]>0 then
  result:=$000001 or FX_COLORMIX
  else
  result:=$000001;
end;

Procedure DrawGHForm(F : TGHForm);
begin
  case F.S.GHDV of
   colored:
    begin
      Pr2D_Rect(F.S.D.X,   F.S.D.Y,         F.S.D.W,   F.S.D.H,         GHColor[F.S.SI,1], F.S.A, 1);
      Pr2D_Rect(F.S.D.X+3, F.S.D.Y+3,       F.S.D.W-6, F.SHH,           GHColor[F.S.SI,2], F.S.A, 1);
      Pr2D_Rect(F.S.D.X+3, F.S.D.Y+6+F.SHH, F.S.D.W-6, F.S.D.H-F.SHH-9, GHColor[F.S.SI,3], F.S.A, 1);
    end;
   easyscin:
     SSprite_Draw( GHScin[F.S.SI].T, F.S.D.X, F.S.D.Y, F.S.D.W, F.S.D.H, F.S.A, 0, GetFL(1));
   scin:
     DrawRobj(F.S, F.R, GetFL(1), F.SHH);
   end;
  DrawGHText(F.Capt);
  DrawGHObj(F.GHObj);
end;

Procedure DrawGHButton(OBJ : TGHButton);
begin
  with OBJ do
   begin
    Case S.GHDV of
     colored:
      begin
        Pr2D_Rect( S.D.X,   S.D.Y,   S.D.W,   S.D.H,   GHColor[S.SI,1], S.A, 1);
        if M=1 then
        Pr2D_Rect( S.D.X+3, S.D.Y+3, S.D.W-6, S.D.H-6, GHColor[S.SI,2], S.A, 1)
        else
        Pr2D_Rect( S.D.X+3, S.D.Y+3, S.D.W-6, S.D.H-6, GHColor[0   ,M], S.A, 1);
      end;
     easyscin:
      SSprite_Draw( GHScin[S.SI].T, S.D.X, S.D.Y, S.D.W, S.D.H, S.A, 0, GetFl(M));
     scin:
      DrawRobj(S, R, GetFl(M), 0);
    end;
   DrawGHText(Capt);
  end;
end;

Procedure DrawGHAButton(OBJ : TGHAButton);
begin
  with OBJ do
   begin
     if S.GHDV=scin then
     ASprite_Draw( GHScin[S.SI].T, S.D.X, S.D.Y, S.D.W, S.D.H, A+M, S.A, 0, GetFl(1))
     else
     ASprite_Draw( GHScin[S.SI].T, S.D.X, S.D.Y, S.D.W, S.D.H, A,   S.A, 0, GetFl(M));
     DrawGHText(Capt);
  end;
end;

Procedure DrawGHCheckBox(OBJ : TGHCheckBox);
var
Fl : integer;
begin
  with OBJ do
   begin
    if S.GHDV=colored then
      begin
        Pr2D_Rect( S.D.X,   S.D.Y,   S.D.W,   S.D.H,   GHColor[S.SI,1], S.A, Fl);
        if M=1 then
        Pr2D_Rect( S.D.X+3, S.D.Y+3, S.D.W-6, S.D.H-6, GHColor[S.SI,3], S.A, Fl)
        else
        Pr2D_Rect( S.D.X+3, S.D.Y+3, S.D.W-6, S.D.H-6, GHColor[0,   M], S.A, Fl);
        if Checked then
         begin
          Pr2D_LineWidth(2);
          Pr2D_Line( S.D.X+5, S.D.Y+5, S.D.X + S.D.W/2, S.D.Y+S.D.H-5, GHColor[S.SI,2], S.A, Fl);
          Pr2D_Line( S.D.X + S.D.W/2, S.D.Y+S.D.H-5, S.D.X+S.D.W-5, S.D.Y,  GHColor[S.SI,2], S.A, Fl);
          Pr2D_LineWidth(1);
         end;
      end
    else
      begin
        if Checked then inc(M,4);
        ASprite_Draw( GHScin[S.SI].T, S.D.X, S.D.Y, S.D.W, S.D.H, M, S.A, 0, GetFl(1));
      end;
   DrawGHText(Capt);
  end;
end;

Procedure DrawGHImage(I : TGHImage);
begin
  SSprite_Draw( GHScin[I.S.SI].T, I.S.D.X, I.S.D.Y, I.S.D.W, I.S.D.H, I.S.A, I.Angle, GetFl(1));
end;

Procedure DrawGHObj(GH : TGHobjects);
var
  I : integer;
begin
  with GH do
    begin
      for I:=0 to length(GHImage)-1 do
      DrawGHImage(GHImage[I]);
      for I:=0 to length(GHLabel)-1 do
      DrawGHText(GHLabel[I].GHCapt);
      for I:=0 to length(GHCheckBox)-1 do
      DrawGHCheckBox(GHCheckBox[I]);
      for I:=0 to length(GHButton)-1 do
      DrawGHButton(GHButton[I]);
      for I:=0 to length(GHAButton)-1 do
      DrawGHAButton(GHAButton[I]);
    end;
end;

Procedure DrawGH;
var
  J : integer;
begin
  if UsedLayer>=0 then
   begin
     DrawGHObj(GHLayer[UsedLayer].GHObj);
     for J:=0 to length(GHLayer[UsedLayer].GHForm)-1 do
     DrawGHForm(GHLayer[UsedLayer].GHForm[J]);
   end;
end;

// . 

Procedure CreatGHColor(A1,B1,C1 : integer);
var
I : integer;
begin
  I:=length(GHColor);
  SetLength(GHColor,I+1);
  GHColor[I,1]:=A1;
  GHColor[I,2]:=B1;
  GHColor[I,3]:=C1;
end;

Procedure CreatGHScin(FN : string; W, H : byte);
var
  I : integer;
begin
  I:=length(GHScin);
  SetLength(GHScin,I+1);
  GHScin[I].S:=FN;
  GHScin[I].T:=Tex_LoadFromFile(PChar(FN), $FFFFFF, TEX_DEFAULT_2D );
  with GHScin[I] do
  Omega.Tex_SetFramesSize(T,T.Width div W, T.Height div H);
end;

Procedure CreatGHFont(FN : string);
begin
  SetLength(GHFont,length(GHFont)+1);
  GHFont[length(GHFont)-1]:= Text_LoadFontFromFile( PChar(FN),PChar(FN+'.ofi'),0,TEX_DEFAULT_2D or TEX_FILTER_NEAREST);
end;

Procedure Test;
var
  S : TGHStandart;
  SC : TGHCapt;
  I : byte;
begin
  CreatGHColor( $FFFFFF, $1199FF, $FF9FFF);
  CreatGHColor( $C2D6C0, $DAE6D9, $E8EEE9);

  CreatGHLayer;
{  writeln('S.D.X');
  readln(S.D.X);
  writeln('S.D.Y');
  readln(S.D.Y);
  writeln('S.D.Width');
  readln(S.D.Width);
  writeln('S.D.Height');
  readln(S.D.Height);
  writeln('S.SI');
  readln(S.SI);
  writeln('S.T');
  readln(S.T);  }

  S.GHDV:=scin;
  S.D.X:=100;
  S.D.Y:=100;
  S.D.W:=230;
  S.D.H:=130;
  

  SC.Tx:='';
  SC.Col:=100;
  SC.Ft:=0;
  SC.Sz:=1;

  S.L:=0;
  S.A:=255;
  S.F:=-1;
  S.SI:=1;
  CreatGHForm(S, SC);
//  CreatGHForm(S, SC);
//  S.GHDV:=scin;

  S.D.X:=165;
  S.D.Y:=165;
  S.D.W:=25;
  S.D.H:=25;
  S.F:= 0;
  S.SI:=0;
  S.GHType:=tCheckBox;
  CreatGHObj(S, SC);
  S.SI:=1;
  S.GHDV:=colored;
  S.D.W:=70;
  S.D.H:=35;
  S.GHType:=tImage;
  for I:=1 to 3 do
  begin
    S.D.Y:=S.D.Y+50;
    CreatGHObj(S, SC);
  end;

end;



end.
