unit Setup;

interface
uses
  LexUtils;

Procedure LoadSetupFile;
Procedure SaveSetupFile;

var
WinW, WinH : integer;
WinColors,  Music, Sound, Talk : byte;
FullWin, VSync : boolean;

implementation

Procedure CreatSetupfile;
begin
  WinW := 800;
  WinH := 600;
  WinColors:=32;
  FullWin := true;
  VSync := false;
  Music :=10;
  Sound :=10;
  Talk :=10;
  SaveSetupFile;
end;

Procedure SaveSetupFile;
var
  Options : textfile;
begin
  assignfile(Options, 'Setup.ini');
  rewrite(Options);
  writeln(Options, '_cdmLex game_');
  writeln(Options, '--');
  writeln(Options, ':');
  writeln(Options, WinW);
  writeln(Options, ':');
  writeln(Options, WinH);
  writeln(Options, ' :');
  writeln(Options, WinColors);
  writeln(Options, ' :');
  writeln(Options, FullWin);
  writeln(Options, ' :');
  writeln(Options, VSync);
  writeln(Options, ' :');
  writeln(Options, Music);
  writeln(Options, ' :');
  writeln(Options, Sound);
  writeln(Options, ' :');
  writeln(Options, Talk);
  CloseFile(Options);
end;


Procedure LoadSetupFile;
///    .
var
Options : TextFile;
Stringer : String;
begin
  if FileEx('Setup.ini') then
    begin
      assignfile(Options, 'Setup.ini');
      reset(Options);
      readln(Options, Stringer);
      if Stringer='_cdmLex game_' then
      begin
      readln(Options, Stringer);
      readln(Options, Stringer);
      readln(Options, Stringer);
      WinW:=s2int(Stringer);
      readln(Options, Stringer);
      readln(Options, Stringer);
      WinH:=s2int(Stringer);
      readln(Options, Stringer);
      readln(Options, Stringer);
      WinColors:=s2int(Stringer);
      readln(Options, Stringer);
      readln(Options, Stringer);
      if Stringer='TRUE' then
        FullWin:=true
      else
        FullWin:=false;
      readln(Options, Stringer);
      readln(Options, Stringer);
      if Stringer='TRUE' then
        VSync:=true
      else
        VSync:=false;
      readln(Options, Stringer);
      readln(Options, Music);
      readln(Options, Stringer);
      readln(Options, Sound);
      readln(Options, Stringer);
      readln(Options, Talk);
      CloseFile(Options);
      end
      else
      begin
        CloseFile(Options);
        CreatSetupfile;
      end;
    end
  else
  CreatSetupfile;

end;


end.
