type
   // GLU types
   GLUNurbs       = record end;
   GLUQuadric     = record end;
   GLUTesselator  = record end;

   PGLUNurbs      = ^GLUNurbs;
   PGLUQuadric    = ^GLUQuadric;
   PGLUTesselator = ^GLUTesselator;

   // backwards compatibility
   GLUNurbsObj        = GLUNurbs;
   GLUQuadricObj      = GLUQuadric;
   GLUTesselatorObj   = GLUTesselator;
   GLUTriangulatorObj = GLUTesselator;

   PGLUNurbsObj        = PGLUNurbs;
   PGLUQuadricObj      = PGLUQuadric;
   PGLUTesselatorObj   = PGLUTesselator;
   PGLUTriangulatorObj = PGLUTesselator;

   // Callback function prototypes
   GLUQuadricErrorProc = procedure(errorCode: GLEnum); stdcall;

   GLUTessBeginProc        = procedure(AType: GLEnum); stdcall;
   GLUTessEdgeFlagProc     = procedure(Flag: GLboolean); stdcall;
   GLUTessVertexProc       = procedure(VertexData: Pointer); stdcall;
   GLUTessEndProc          = procedure; stdcall;
   GLUTessErrorProc        = procedure(ErrNo: GLEnum); stdcall;
   GLUTessCombineProc      = procedure(Coords: TVector3d; VertexData: TVector4p; Weight: TVector4f; OutData: PPointer); stdcall;
   GLUTessBeginDataProc    = procedure(AType: GLEnum; UserData: Pointer); stdcall;
   GLUTessEdgeFlagDataProc = procedure(Flag: GLboolean; UserData: Pointer); stdcall;
   GLUTessVertexDataProc   = procedure(VertexData: Pointer; UserData: Pointer); stdcall;
   GLUTessEndDataProc      = procedure(UserData: Pointer); stdcall;
   GLUTessErrorDataProc    = procedure(ErrNo: GLEnum; UserData: Pointer); stdcall;
   GLUTessCombineDataProc  = procedure(Coords: TVector3d; VertexData: TVector4p; Weight: TVector4f; OutData: PPointer; UserData: Pointer); stdcall;

   GLUNurbsErrorProc       = procedure(ErrorCode: GLEnum); stdcall;
