{------------------------------------------------------------------------------}
{ SibVRV
{ svGE Unit
{ Created 23.04.1999 by Vereshagin Roman Vladimirovich.
{ - M 25.05.2001 by Vereshagin Roman Vladimirovich. - converted to class
{ History:
{  VR - Unit Created
{ // Warning : This is a part of svVirtualAI !!!
{------------------------------------------------------------------------------}
unit svFiles;

interface
// TODO : svisFileExist
Type
 TsvFile = class;
 TsvFile = class
           private
            procedure SetPosition(const Value: Longint);
            function GetPosition: Longint;
           public
            IsSave    : Boolean;
            IsCreated : Boolean;
            OpenedFile: File;

            property Position:Longint read GetPosition write SetPosition;

            constructor Create;
            destructor Destroy;override;

            Function svOpenFile(FileName:String):Boolean;
            Function svSaveFile(FileName:String):Boolean;
            Procedure svCloseFile;

            Procedure svFileIO(var Value;Size:LongWord);overload;
            Procedure svFileIO(var Value:Integer);overload;
            Procedure svFileIO(var Value:String); overload;
            Procedure svFileIO(var Value:Boolean);overload;
            Function svFileIO_Check(const Value : String):Boolean;
            Function svFileSize : Longint;
           end;


implementation

procedure TsvFile.svFileIO(var Value; Size: LongWord);//AnySize
begin
if not IsCreated then exit;
if IsSave then BlockWrite(OpenedFile,Value,Size) else
               BlockRead (OpenedFile,Value,Size);
end;

Procedure TsvFile.svFileIO(var Value:Boolean); // BOOLEAN
begin
  svFileIO(Value,SizeOf(Value));
end;

Procedure TsvFile.svFileIO(var Value:Integer); // INTEGER
begin
  svFileIO(Value,SizeOf(Value));
end;

Procedure TsvFile.svFileIO(var Value:String);  // STRING
var
 StringSize  :Integer;
begin
if not IsCreated then exit;
if IsSave       then StringSize:=Length(Value);
                     svFileIO(StringSize);
if not IsSave   then SetLength(Value,StringSize);
if StringSize>0 then svFileIO(Value[1],StringSize);
end;

function TsvFile.svFileIO_Check(const Value: String): Boolean;
var
 ID : String;
begin
 Result := False;
 if not IsCreated then exit;

 ID := Value;
 svFileIO(ID[1],Length(ID));
 if ID=Value then Result := True;
// if IsSave   then Result := True; //
end;

Function TsvFile.svOpenFile(FileName:String):Boolean;
begin
IsSave:=False;
IsCreated:=False;
if FileName<>'' then
 begin
  AssignFile(OpenedFile,FileName);
  {$I-} Reset(OpenedFile,1);    {$I+}
  if IOResult <> 0 then svCloseFile else IsCreated:=True;
 end;
Result:=IsCreated;
end;

Function TsvFile.svSaveFile(FileName:String):Boolean;
begin
IsSave:=True;
IsCreated:=False;
if FileName<>'' then
 begin
  AssignFile(OpenedFile,FileName);
  {$I-} Rewrite(OpenedFile,1);  {$I+}
  if IOResult <> 0 then svCloseFile else IsCreated:=True;
 end;
Result:=IsCreated;
end;

Procedure TsvFile.svCloseFile;
begin
IsSave   :=False;
if IsCreated then CloseFile(OpenedFile);
   IsCreated:=False;
end;

constructor TsvFile.Create;
begin
inherited;
IsSave    := false;
IsCreated := false;
end;

destructor TsvFile.Destroy;
begin
svCloseFile;
inherited;
end;

procedure TsvFile.SetPosition(const Value: Longint);
begin
if IsCreated then Seek(OpenedFile,Value);
end;

function TsvFile.GetPosition: Longint;
begin
Result:=0;
if IsCreated then Result := FilePos(OpenedFile);
end;

function TsvFile.svFileSize: Longint;
begin
Result := 0;
if IsCreated then Result := FileSize(OpenedFile);
end;

end.
