unit uWeapon;

interface
uses
  zglHeader;

const
  wt_Simple  = 0;
  wt_Simple2 = 1;

type
  TWeapon = record
    _type    : Byte;
    Fire     : Double;
    byPlayer : Boolean;
    Speed    : Integer;
    Count    : Integer;
    nCount   : Integer;
end;

procedure weapon_Init( var Weapon : TWeapon; aType : Byte; abyPlayer : Boolean );
procedure weapon_Fire( var Weapon : TWeapon; aX, aY, aZ : Single );

implementation
uses
  uBullets, uPlayer, uRes;

procedure weapon_Init;
begin
  with Weapon do
    begin
      _type     := aType;
      Fire      := timer_GetTicks;
      byPlayer  := abyPlayer;
      case aType of
        wt_Simple:
          begin
            Speed  := 250;
            Count  := 0;
            nCount := 1;
          end;
        wt_Simple2:
          begin
            Speed  := 350;
            Count  := 0;
            nCount := 2;
          end;
      end;
    end;
end;

procedure weapon_Fire;
begin
  with Weapon do
    begin
      if timer_GetTicks > Fire + Speed Then Count := 0;

      if Count = 0 Then
        begin
          if byPlayer Then
            snd_Play( s_Shoot2, 0, 0, 6 )
          else
            snd_Play( s_Shoot1, aX - Player.Col.Position.X, aY - Player.Col.Position.Y, aZ - Player.Col.Position.Z );
        end;

      case _type of
        wt_Simple:
          begin
            if Count < nCount Then
              begin
                bullets_Add( _type, aX, aY, aZ, byPlayer );
                Fire := timer_GetTicks();
              end;
            INC( Count );
          end;
        wt_Simple2:
          begin
            if Count < nCount Then
              begin
                bullets_Add( wt_simple, aX, aY, aZ, byPlayer );
                Fire := timer_GetTicks();
              end;
            INC( Count );
          end;
      end;
    end;
end;

end.
