unit uPlayer;

interface
uses
  zglHeader, uWeapon;

type
  TPlayer = record
    Col    : zglTAABB;
    Move   : Single;
    Matrix : zglTMatrix4f;
    yAngle : Single;

    Life : Integer;
    Kill : Boolean;

    Weapon : TWeapon;
end;

procedure player_Add;
procedure player_Draw;
procedure player_Proc;

var
  Player : TPlayer;
  Camera : zglTCamera3D;

implementation
uses
  uMain, uParticles, uRes;

procedure player_Add;
begin
  with Player do
    begin
      Col.Size.X := 0.2;
      Col.Size.Y := 0.1;
      Col.Size.Z := 0.35;
      Life       := 3000;

      weapon_Init( Weapon, wt_Simple, TRUE );
    end;
end;

procedure player_Draw;
begin
  with Player do
    begin
      obj3d_Begin( OBJ3D_TEXTURING or OBJ3D_CULL_FACE or OBJ3D_BLEND );
        obj3d_MulMatrix( @Matrix );

        obj3d_BindTexture( tex_car[ 0 ], 0 );
        smesh_Draw( sm_player[ 0 ] );
        obj3d_BindTexture( tex_car[ 1 ], 0 );
        smesh_Draw( sm_player[ 1 ] );

        obj3d_SetColor( $FFFFFF, 200 );
        obj3d_BindTexture( tex_car[ 2 ], 0 );
        smesh_Draw( sm_player[ 2 ] );

        if debug Then
          begin
            obj3d_Move( 0, 0.1, 0 );
            obj3d_Disable( OBJ3D_TEXTURING );
            obj3d_Enable( OBJ3D_WIRE_FRAME );
            pr3d_AABB( Col.Size.X, Col.Size.Y, Col.Size.Z );
            obj3d_Disable( OBJ3D_WIRE_FRAME );
          end;
      obj3d_End;
    end;
end;

procedure player_Proc;
  var
    pv : zglTPoint3D;
begin
  with Player do
    begin
      if Player.Life <= 0 Then
        begin
          plane := heightmap_GetPlane( hm_map01, Col.Position );
          if Col.Position.Y < hm_map01.Vertices[ hm_map01.Faces[ plane ].vIndex[ 0 ] ].Y - 29.5 then
            begin
              if Kill Then exit;
              particles_Add( pt_boom, Col.Position.X, Col.Position.Y, Col.Position.Z );
              particles_Add( pt_boom, Col.Position.X, Col.Position.Y, Col.Position.Z );
              particles_Add( pt_boom, Col.Position.X, Col.Position.Y, Col.Position.Z );
              Kill := TRUE;
              exit;
            end;
          Col.Position.Y := Col.Position.Y - 0.05;
          Col.Position.Z := Col.Position.Z - 0.07;
          yAngle         := yAngle + 2;

          matrix4f_Translate( @Matrix, Col.Position.X, Col.Position.Y - 0.1, Col.Position.Z );
          matrix4f_Rotate( @Matrix, 0, ( 180 + yAngle ) * cv_pi180, Move );

          exit;
        end;

      Col.Position.X := Col.Position.X + mouse_DX / 400;
      Col.Position.Y := 0;
      Col.Position.Z := Col.Position.Z + mouse_DY / 400;
      if Col.Position.Z - Camera.Position.Z > -2.5 Then Col.Position.Z := Camera.Position.Z - 2.5;
      if Col.Position.Z - Camera.Position.Z < -6   Then Col.Position.Z := Camera.Position.Z - 6;
      if Col.Position.X >  5 Then Col.Position.X :=  5;
      if Col.Position.X < -5 Then Col.Position.X := -5;

      Camera.Position.X := Col.Position.X / 2;

      Move := Move - mouse_DX / 250;
      if Move > 0 Then Move := Move - 0.03;
      if Move < 0 Then Move := Move + 0.03;
      if Move >  0.75 Then Move :=  0.75;
      if Move < -0.75 Then Move := -0.75;

      matrix4f_Translate( @Matrix, Col.Position.X, Col.Position.Y - 0.1, Col.Position.Z );
      matrix4f_Rotate( @Matrix, 0, 180 * cv_pi180, Move );

      pv.X :=  0.1;
      pv.Y :=  0.15;
      pv.Z := -0.35;
      pv := vector_MulM4f( pv, @Matrix );
      particles_Add( pt_sopla, pv.X, pv.Y, pv.Z );
      pv.X := -0.1;
      pv.Y :=  0.15;
      pv.Z := -0.35;
      pv := vector_MulM4f( pv, @Matrix );
      particles_Add( pt_sopla, pv.X, pv.Y, pv.Z );

      if mouse_Down( M_BLEFT ) Then
        case Weapon._type of
          wt_simple:
            begin        
              pv.X := 0;
              pv.Y := 0.15;
              pv.Z := 0.35;
              pv := vector_MulM4f( pv, @Matrix );
              weapon_Fire( Weapon, pv.X, pv.Y, pv.Z );
            end;
          wt_simple2:
            begin        
              pv.X := -0.1;
              pv.Y := 0.15;
              pv.Z := 0.35;
              pv := vector_MulM4f( pv, @Matrix );
              weapon_Fire( Weapon, pv.X, pv.Y, pv.Z );

              pv.X := 0.1;
              pv.Y := 0.15;
              pv.Z := 0.35;
              pv := vector_MulM4f( pv, @Matrix );
              weapon_Fire( Weapon, pv.X, pv.Y, pv.Z );
            end;
        end;
    end;
end;

end.
