{------------------------------------------------------------------------------}
{ SibVRV
{ svWinGL Unit
{ Created 11.04.2002 by Vereshagin Roman Vladimirovich.
{ History:
(  VR - Unit Created
{------------------------------------------------------------------------------}
unit svVectorTypes;

interface

type
  TVector2f = array[0..1] of single;
  TVector2d = array[0..1] of double;
  TVector2i = array[0..1] of longint;
  TVector2s = array[0..1] of smallint;
  TVector2p = array[0..1] of Pointer;

  TVector3f = array[0..2] of single;
  TVector3d = array[0..2] of double;
  TVector3i = array[0..2] of longint;
  TVector3s = array[0..2] of smallint;
  TVector3p = array[0..2] of Pointer;

  TVector4f = array[0..3] of single;
  TVector4d = array[0..3] of double;
  TVector4i = array[0..3] of longint;
  TVector4s = array[0..3] of smallint;
  TVector4p = array[0..3] of Pointer;

  TMatrix3f = array[0..2] of TVector3f;
  TMatrix3d = array[0..2] of TVector3d;
  TMatrix3i = array[0..2] of TVector3i;
  TMatrix3s = array[0..2] of TVector3s;
  TMatrix3p = array[0..2] of TVector3p;

  TMatrix4f = array[0..3] of TVector4f;
  TMatrix4d = array[0..3] of TVector4d;
  TMatrix4i = array[0..3] of TVector4i;
  TMatrix4s = array[0..3] of TVector4s;
  TMatrix4p = array[0..3] of TVector4p;

{$I 'svVectorTypes/svD3D.inc'}
{$I 'svVectorTypes/svNullVectors.inc'}

procedure ResetVector(var v : TVector2f);overload;
procedure ResetVector(var v : TVector3f);overload;
procedure ResetVector(var v : TVector4f);overload;

// Vectors 2
Function  Vector2f(x, y :single  ): TVector2f;overload;
Function  Vector2d(x, y :double  ): TVector2d;
Function  Vector2i(x, y :longint ): TVector2i;
Function  Vector2s(x, y :smallint): TVector2s;

Function  Vector2f(vec :TVector3f): TVector2f;overload;
// Vectors 3
Function  Vector3i(x,y,z:longint) : TVector3i;overload;
Function  Vector3i(vec:TVector3f) : TVector3i;overload;

Function  Vector3f(x,y,z:Single ) : TVector3f;overload;
Function  Vector3f(vec:Tvector4f) : TVector3f;overload;
Function  Vector3f(vec:Tvector3i) : TVector3f;overload;
Function  Vector3f(vec:Tvector2f) : TVector3f;overload;

Function  Vector3d(x,y,z:Double)   : TVector3d;
Function  Vector3s(x,y,z:smallint) : TVector3s;

function  Vector3fInvet(vec : TVector3f):TVector3f;
// Vectors 4
Function  Vector4f(x,y,z : single ;const w:Single=1)  : TVector4f; overload;
Function  Vector4f(vec : TVector3f;const w:Single=1) : TVector4f; overload;

Function  Vector4d(x,y,z,w:Double)   : TVector4d;
Function  Vector4i(x,y,z,w:longint)  : TVector4i;
Function  Vector4s(x,y,z,w:smallint) : TVector4s;

function  Vector4fInvet(vec : TVector4f):TVector4f;

function isNullVector(Value: TVector3f):Boolean;

function RandomVector3f(V : TVector3f):TVector3f;

implementation

procedure ResetVector(var v : TVector2f);overload; {$I 'svVectorTypes/svXOR_edx_eax.inc'}
end;
procedure ResetVector(var v : TVector3f);overload; {$I 'svVectorTypes/svXOR_edx_eax.inc'}
  mov   [eax+8], edx
end;
procedure ResetVector(var v : TVector4f);overload; {$I 'svVectorTypes/svXOR_edx_eax.inc'}
  mov   [eax+8] , edx
  mov   [eax+12], edx
end;
// Vectors 2
Function Vector2f(x, y :single  ): TVector2f; {$I 'svVectorTypes/svResultXY.inc'}
Function Vector2d(x, y :double  ): TVector2d; {$I 'svVectorTypes/svResultXY.inc'}
Function Vector2i(x, y :longint ): TVector2i; {$I 'svVectorTypes/svResultXY.inc'}
Function Vector2s(x, y :smallint): TVector2s; {$I 'svVectorTypes/svResultXY.inc'}

Function Vector2f(vec :TVector3f): TVector2f;
 begin
  Result[0] := vec[0];
  Result[1] := vec[1];
 end;
// Vectors 3
Function  Vector3i(x,y,z:longint): TVector3i;overload;{$I 'svVectorTypes/svResultXYZ.inc'}
Function  Vector3i(vec:TVector3f): TVector3i;overload;
begin
  Result[0]:=Trunc(vec[0]);
  Result[1]:=Trunc(vec[1]);
  Result[2]:=Trunc(vec[2]);
end;

Function  Vector3f(x,y,z:Single ): TVector3f;overload;{$I 'svVectorTypes/svResultXYZ.inc'}
Function  Vector3f(vec:Tvector4f): TVector3f;overload;{$I 'svVectorTypes/svResultVec3f.inc'}
Function  Vector3f(vec:Tvector3i): TVector3f;overload;{$I 'svVectorTypes/svResultVec3f.inc'}
Function  Vector3f(vec:Tvector2f): TVector3f;overload;
 begin
  Result[0] := vec[0];
  Result[1] := vec[1];
  Result[2] := 0;
 end;

Function  Vector3d(x,y,z:Double)   : TVector3d;{$I 'svVectorTypes/svResultXYZ.inc'}
Function  Vector3s(x,y,z:smallint) : TVector3s;{$I 'svVectorTypes/svResultXYZ.inc'}

function  Vector3fInvet(vec : TVector3f):TVector3f;{$I 'svVectorTypes/svInvResultXYZ.inc'}

// Vectors 4
Function  Vector4f(x,y,z:single;const w:Single=1) : TVector4f; overload;{$I 'svVectorTypes/svResultXYZW.inc'}
Function  Vector4f(vec:TVector3f;const w:Single=1)  : TVector4f; overload;
 begin
   Result:=Vector4f(vec[0],vec[1],vec[2],w);
 end;

Function  Vector4d(x,y,z,w:Double)   : TVector4d; {$I 'svVectorTypes/svResultXYZW.inc'}
Function  Vector4i(x,y,z,w:longint)  : TVector4i; {$I 'svVectorTypes/svResultXYZW.inc'}
Function  Vector4s(x,y,z,w:smallint) : TVector4s; {$I 'svVectorTypes/svResultXYZW.inc'}


function  Vector4fInvet(vec : TVector4f):TVector4f;
begin
Result[0] := - vec[0];
Result[1] := - vec[1];
Result[2] := - vec[2];
//Result[3] := 0;
end;

function isNullVector(Value: TVector3f):Boolean;
begin
Result := (Value[0]=0) and (Value[1]=0) and (Value[2]=0);
end;

function RandomVector3f(V : TVector3f):TVector3f;
begin
 Result := Vector3f(Random*v[0],Random*v[1],Random*v[2])
end;

end.
