{------------------------------------------------------------------------------}
{ SibVRV
{ svGE Unit
{ Created 11.04.2001 by Vereshagin Roman Vladimirovich.
{ History:
(  VR - Unit Created
{------------------------------------------------------------------------------}
unit svStrings;

interface

 Uses
  svVectorTypes;

type
  TCharSet = set of Char;

const
  DigitChars    = ['0'..'9'];
  StdSpecial    = ['?','!','<','>','~','@','#','$','%','^','&','*','+'];
  Brackets      = ['(',')','[',']','{','}'];        
  StdWordDelims = [#0..' ',',','.',';','/','\',':','''','"','`'] + Brackets + StdSpecial;


  svSTR_SIBVRV         = 'SibVRV';
  svSTR_Engine         = ' Engine ';
  svSTR_Version        = ' version ';

  svSTR_Setup          = 'Setup';
  svSTR_Resolution     = 'Resolution';
  svSTR_ColorDepth     = 'Color Depth';
  svSTR_OpenGL         = 'OpenGL';  {<< Dont Change this string <<}

  svSTR_Kernel         = 'Kernel';

 function StrPas(const Str: PChar): string;
 function IntToStr(Num : Integer) : String;
 function StrToInt(const S: string): Integer;
 function FloatToStr(const f:Single): String;
 function Vec3ftoStr(vec: TVector3f): string;

 function WordCount(const S: string; const WordDelims: TCharSet): Integer;

 function WordPosition(const N: Integer; const S: string; const WordDelims: TCharSet): Integer;
 function ExtractWord(N: Integer; const S: string; const WordDelims: TCharSet): string;

implementation

function StrPas(const Str: PChar): string;
begin
  Result := Str;
end;

function IntToStr(Num : Integer) : String;
begin Str(Num, result); end;

function StrToInt(const S: string): Integer;
var
  E: Integer;
begin
  Val(S, Result, E);
  if E<>0 then Result:=-1;
end;

function FloatToStr(const f:Single): String;
begin
if f<0 then Result:='-' else Result:='';
Result:=Result+IntToStr(Abs(Trunc(f)))+'.'+IntToStr(Abs(Trunc((f-Trunc(f))*100)));
end;

function Vec3ftoStr(vec: TVector3f): string;
begin
Result :=FloatToStr(vec[0])+' : '+FloatToStr(vec[1])+' : '+FloatToStr(vec[2]);
end;

function WordCount(const S: string; const WordDelims: TCharSet): Integer;
var
  SLen, I: Cardinal;
begin
  Result := 0;
  I := 1;
  SLen := Length(S);
  while I <= SLen do begin
    while (I <= SLen) and (S[I] in WordDelims) do Inc(I);
    if I <= SLen then Inc(Result);
    while (I <= SLen) and not(S[I] in WordDelims) do Inc(I);
  end;
end;

function WordPosition(const N: Integer; const S: string;
  const WordDelims: TCharSet): Integer;
var
  Count, I: Integer;
begin
  Count := 0;
  I := 1;
  Result := 0;
  while (I <= Length(S)) and (Count <> N) do begin
    { skip over delimiters }
    while (I <= Length(S)) and (S[I] in WordDelims) do Inc(I);
    { if we're not beyond end of S, we're at the start of a word }
    if I <= Length(S) then Inc(Count);
    { if not finished, find the end of the current word }
    if Count <> N then
      while (I <= Length(S)) and not (S[I] in WordDelims) do Inc(I)
    else Result := I;
  end;
end;

function ExtractWord(N: Integer; const S: string;
  const WordDelims: TCharSet): string;
var
  I: Integer;
  Len: Integer;
begin
  Len := 0;
  I := WordPosition(N, S, WordDelims);
  if I <> 0 then
    { find the end of the current word }
    while (I <= Length(S)) and not(S[I] in WordDelims) do begin
      { add the I'th character to result }
      Inc(Len);
      SetLength(Result, Len);
      Result[Len] := S[I];
      Inc(I);
    end;
  SetLength(Result, Len);
end;


end.


