{------------------------------------------------------------------}
{                                                                  }
{            DDS  Sovetnik'        }
{                                                                  }
{                :  17.12.06                                 }
{    :  13.01.07                                 }
{                                                                  }
{   :                                         }
{  -    http://www.UltimateGameProgramming.com/                }
{  -   OpenGL 2.0 ( GL 1.1 - 2.0)       }
{     DGL-OpenGL2-Portteam                                       }
{  -    ddraw.h                 }
{    (Alexey Barkovoy), JEDI                                       }
{                                                                  }
{     http://www.nVidia.com/                  }
{      Photoshop                           }
{                                                                  }
{------------------------------------------------------------------}
unit sovDDS;

interface

uses
  OpenGL;

const
  //  Windows
  opengl32 = 'opengl32.dll';
  //  OpenGL
  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = $83F1;
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = $83F2;
  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = $83F3;
  //  DirectDraw
  FOURCC_DXT1 = $31545844;
  FOURCC_DXT3 = $33545844;
  FOURCC_DXT5 = $35545844;

type
  //   Windows
  DWORD = Longword;
  //   DirectDraw
  PDDColorKey = ^TDDColorKey;
  _DDCOLORKEY = packed record
    dwColorSpaceLowValue: DWORD;   // low boundary of color space that is to
                                   // be treated as Color Key, inclusive
    dwColorSpaceHighValue: DWORD;  // high boundary of color space that is
                                   // to be treated as Color Key, inclusive
  end;
  {$EXTERNALSYM _DDCOLORKEY}
  DDCOLORKEY = _DDCOLORKEY;
  {$EXTERNALSYM DDCOLORKEY}
  TDDColorKey = _DDCOLORKEY;
  PDDPixelFormat = ^TDDPixelFormat;
  _DDPIXELFORMAT = packed record
    dwSize: DWORD;                 //  
    dwFlags: DWORD;                //   
    dwFourCC: DWORD;               //  FOURCC
    case Integer of
      1: (
          dwRGBBitCount : DWORD;          //    
          dwRBitMask : DWORD;             //    
          dwGBitMask : DWORD;             //    
          dwBBitMask : DWORD;             //    
          dwRGBAlphaBitMask : DWORD;      //   -
          );
      2: (
          dwYUVBitCount : DWORD;          //    
          dwYBitMask : DWORD;             //   Y-
          dwUBitMask : DWORD;             //   U-
          dwVBitMask : DWORD;             //   V-
          dwYUVAlphaBitMask : DWORD;      //   -
          );
      3: (
          dwZBufferBitDepth : DWORD;      // how many total bits/pixel in z buffer (including any stencil bits)
          dwStencilBitDepth : DWORD;      // how many stencil bits (note: dwZBufferBitDepth-dwStencilBitDepth is total Z-only bits)
          dwZBitMask : DWORD;             //   Z-
          dwStencilBitMask : DWORD;       // mask for stencil bits
          dwLuminanceAlphaBitMask : DWORD; //   -
          );
      4: (
          dwAlphaBitDepth : DWORD;        //    -
          dwLuminanceBitMask : DWORD;     // mask for luminance bits
          dwBumpDvBitMask : DWORD;        // mask for bump map V delta bits
          dwBumpLuminanceBitMask : DWORD; // mask for luminance in bump map
          dwRGBZBitMask : DWORD;          //   Z-
          );
      5: (
           dwLuminanceBitCount : DWORD;   //    
           dwBumpDuBitMask : DWORD;       // mask for bump map U delta bits
           Fill1, Fill2    : DWORD;
           dwYUVZBitMask   : DWORD;       //   Z-
         );
      6: ( dwBumpBitCount  : DWORD;       // how many bits per "buxel", total
         );
  end;
  {$EXTERNALSYM _DDPIXELFORMAT}
  DDPIXELFORMAT = _DDPIXELFORMAT;
  {$EXTERNALSYM DDPIXELFORMAT}
  TDDPixelFormat = _DDPIXELFORMAT;
  PDDSCaps2 = ^TDDSCaps2;
  _DDSCAPS2 = packed record
    dwCaps: DWORD;         //   
    dwCaps2 : DWORD;
    dwCaps3 : DWORD;
    dwCaps4 : DWORD;
  end;
  {$EXTERNALSYM _DDSCAPS2}
  DDSCAPS2 = _DDSCAPS2;
  {$EXTERNALSYM DDSCAPS2}
  TDDSCaps2 = _DDSCAPS2;
  PDDSurfaceDesc2 = ^TDDSurfaceDesc2;
  _DDSURFACEDESC2 = packed record
    dwSize: DWORD;                       //   TDDSurfaceDesc
    dwFlags: DWORD;                      // determines what fields are valid
    dwHeight: DWORD;                     //    
    dwWidth: DWORD;                      //   
    case Integer of
    0: (
      lPitch : Longint;                  // distance to start of next line (return value only)
     );
    1: (
      dwLinearSize : DWORD;              // Formless late-allocated optimized surface size
      dwBackBufferCount: DWORD;          // number of back buffers requested
      case Integer of
      0: (
        dwMipMapCount: DWORD;            // number of mip-map levels requested
        dwAlphaBitDepth: DWORD;          // depth of alpha buffer requested
        dwReserved: DWORD;               // reserved
        lpSurface: Pointer;              // pointer to the associated surface memory
        ddckCKDestOverlay: TDDColorKey;  // color key for destination overlay use
        ddckCKDestBlt: TDDColorKey;      // color key for destination blt use
        ddckCKSrcOverlay: TDDColorKey;   // color key for source overlay use
        ddckCKSrcBlt: TDDColorKey;       // color key for source blt use
        ddpfPixelFormat: TDDPixelFormat; // pixel format description of the surface
        ddsCaps: TDDSCaps2;              // direct draw surface capabilities
        dwTextureStage: DWORD;           // stage in multitexture cascade
       );
      1: (
        dwRefreshRate: DWORD;            // refresh rate (used when display mode is described)
       );
     );
  end;
  {$EXTERNALSYM _DDSURFACEDESC2}
  DDSURFACEDESC2 = _DDSURFACEDESC2;
  {$EXTERNALSYM DDSURFACEDESC2}
  TDDSurfaceDesc2 = _DDSURFACEDESC2;
  //   OpenGL
  TglCompressedTexImage2DARB = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; const data: Pointer); stdcall;
  //    TDDS
  TDDS = class
  private
    // 
    ID: GLuint;
    imageWidth: DWORD;
    imageHeight: DWORD;
    image: Pointer;
    ttype: DWORD;
    totalComponents: DWORD;
    totalMips: DWORD;
    totalSize: DWORD;
    //   
    function LoadDDSFile(filename: String): boolean;
    procedure FreeImage;
  public
    constructor Create;
    destructor Destroy;
    //   
    procedure InitTexture(filename: String);
    procedure ShowTexture;
    procedure FreeTexture;
  end;

implementation
//   OpenGL
procedure glGenTextures (n: GLsizei; textures: PGLuint); stdcall; external opengl32;
procedure glBindTexture (target: GLEnum; texture: GLuint); stdcall; external opengl32;
procedure glDeleteTextures (n: GLsizei; textures: PGLuint); stdcall; external opengl32;

procedure TDDS.FreeImage;
begin
//    
  if not (image = nil) then
  begin
    FreeMem(image, totalSize);
    image := nil;
    ttype := 0;
    imageWidth := 0;
    imageHeight := 0;
    totalComponents := 0;
    totalMips := 0;
  end;
end;

constructor TDDS.Create;
begin
//      
  image := nil;
  ttype := 0;
  ID := 0;
  imageWidth := 0;
  imageHeight := 0;
  totalComponents := 0;
  totalMips := 0;
end;

destructor TDDS.Destroy;
begin
  FreeImage;
end;

function TDDS.LoadDDSFile(filename: String): boolean;
var
  fp: File;
  ddsd: TDDSurfaceDesc2;
  imageID: array[1..4] of Char;
  mipFactor: DWORD;
  imageSize: DWORD;
  rcount: Integer;
begin
  FreeImage;
  mipFactor := 0;
  totalSize := 0;
  imageSize := 0;
  AssignFile(fp, filename);
  ReSet(fp, 1);
//  - DDS   ?
  BlockRead(fp, imageID, 4);
  if not((imageID[1] = 'D') and (imageID[2] = 'D') and (imageID[3] = 'S') and (imageID[4] = ' ')) then
  begin
    CloseFile(fp);
    Result := false;
    Exit;
  end;
//    
  BlockRead(fp, ddsd, sizeof(ddsd));
// ,      
  if not(ddsd.dwLinearSize = 0) then
    imageSize := ddsd.dwLinearSize
  else
    imageSize := ddsd.dwHeight * ddsd.dwWidth;
//   
  if imageSize <= 0 then
  begin
    CloseFile(fp);
    Result := false;
    Exit;
  end;
  totalMips := ddsd.dwMipMapCount;   
  imageWidth := ddsd.dwWidth;
  imageHeight := ddsd.dwHeight;
//  DXT1   8  1,  DXT3 - 4  1,   DXT5 - 4  1
  case ddsd.ddpfPixelFormat.dwFourCC of
    FOURCC_DXT1:
    begin
      mipFactor := 2;
      totalComponents := 3;
      ttype := GL_COMPRESSED_RGBA_S3TC_DXT1_EXT;
    end;
    FOURCC_DXT3:
    begin
      mipFactor := 4;
      totalComponents := 4;
      ttype := GL_COMPRESSED_RGBA_S3TC_DXT3_EXT;
    end;
    FOURCC_DXT5:
    begin
      mipFactor := 4;
      totalComponents := 4;
      ttype := GL_COMPRESSED_RGBA_S3TC_DXT5_EXT;
    end
    else
    begin
      CloseFile(fp);
      Result := false;
      Exit;
    end;
  end;
//       -  -  ,     - 
  if ddsd.dwMipMapCount > 1 then
    totalSize := imageSize * mipFactor
  else
    totalSize := imageSize;
//     - 
  GetMem(image, totalSize);
// ,   
  if image = nil then
  begin
    CloseFile(fp);
    Result := false;
    Exit;
  end;
//  
  BlockRead(fp, image^, totalSize, rcount);
  CloseFile(fp);
  Result := true;
end;

procedure TDDS.InitTexture(filename: string);
var
  GL_ARB_texture_compression: Boolean;
  glCompressedTexImage2DARB: TglCompressedTexImage2DARB;
  Buffer: String;
  w, h, mipSize, mipOffset, mipFactor: Integer;
  i: Integer;

  //      
  function CheckExtension(const Extension: string): Boolean;
  var
    ExtPos: Integer;
  begin
    //         
    ExtPos := Pos(Extension, Buffer);
    Result := ExtPos > 0;
    //  ,      
    if Result then
      Result := ((ExtPos + Length(Extension) - 1) = Length(Buffer)) or
        not (AnsiChar(Buffer[ExtPos + Length(Extension)]) in ['_', 'A'..'Z', 'a'..'z']);
  end;

begin
  Buffer := glGetString(GL_EXTENSIONS);
  GL_ARB_texture_compression := CheckExtension('GL_ARB_texture_compression');
  //    
  if GL_ARB_texture_compression then
  begin
    glCompressedTexImage2DARB := TglCompressedTexImage2DARB(wglGetProcAddress('glCompressedTexImage2DARB'));
    //     glCompressedTexImage2DARB   ( -    :))
    if LoadDDSFile(filename) then
    begin
      glEnable(GL_TEXTURE_2D);
      glGenTextures(1, @ID);
      glBindTexture(GL_TEXTURE_2D, ID);
      w := imageWidth;
      h := imageHeight;
      mipOffset := 0;
      mipFactor := 0;
      if ttype = GL_COMPRESSED_RGBA_S3TC_DXT1_EXT then
        mipFactor := 8
      else
        mipFactor := 16;
      //    mip-map  
      for i := 0 to totalMips - 1 do
      begin
        mipSize := ((w + 3) shr 2) * ((h + 3) shr 2) * mipFactor;
        glCompressedTexImage2DARB(GL_TEXTURE_2D, i, ttype, w, h, 0, mipSize, POINTER(DWORD(image) + mipOffset));
        //      mip-map 
        w := w shr 1;
        h := h shr 1;
        //     mip-map 
        inc(mipOffset, mipSize);
      end;
      glDisable(GL_TEXTURE_2D);
    end
    else
    begin
      //      ,  
    end;
  end
  else
  begin
    //      ,  
  end;
end;

procedure TDDS.ShowTexture;
begin
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, ID);
end;

procedure TDDS.FreeTexture;
begin
  glDisable(GL_TEXTURE_2D);
  glDeleteTextures(1, @ID);
  FreeImage;
end;

initialization

end.