{------------------------------------------------------------------}
{                                                                  }
{     MIDI                                    }
{                                                                  }
{  Copyright (C) 1997-98 TothPaul@mygale.org                       }
{  http://www.mygale.org/~tothpaul                                 }
{                                                                  }
{    : Sovetnik, 02.05.06                    }
{                                                                  }
{------------------------------------------------------------------}

unit PlayMIDI;
 
interface

uses  Windows   //  ! :)
,     MMSystem  //     
;

procedure StartSound(hwnd : HWND; FileName : PChar); //  ,
procedure Replay;                                    // 
procedure StopSound;                                 //  

implementation

var
  DevId : word;
  mciPlay : TMCI_PLAY_PARMS;
  playing : boolean;  //   ?

procedure StartSound(hwnd : HWND; FileName : PChar);
var
  mciOpen : TMCI_OPEN_PARMS;
begin
  if playing then StopSound; //   - ,   
  with mciOpen do begin
    dwCallBack := 0;
    lpstrDeviceType := nil;
    lpstrElementName := FileName;
    lpstrAlias := nil;
  end;
  if mciSendCommand(0, mci_Open, mci_open_element, Longint(@mciOpen)) = 0 then begin
    DevId := mciOpen.wDeviceId;
    mciPlay.dwCallBack := HWnd;
    mciPlay.dwFrom := 0;
    playing := (mciSendCommand(DevID, mci_Play, mci_notify or mci_from, Longint(@mciPlay)) = 0);
    if not playing then StopSound;
  end;
end;

procedure Replay;
begin
  if playing then
    mciSendCommand(DevID, mci_Play, mci_notify or mci_from, Longint(@mciPlay));
end;

procedure StopSound;
begin
  mciSendCommand(DevID, mci_Close, 0, 0);
  playing := false;
end;

end.
