// ..  ))        )
#include "Engine\OMEGA_code.cpp"
#include "Engine\OMEGA_functions.h"
#include "malloc.h"
#include "stdlib.h"
//#include <iostream.h>
//#include <fstream.h>
#include <ctime>
//#include <stdio.h>
#include "game.h"


///////////////
//****GUI****//
///////////////
TGUI::TGUI(void) {}
TGUI::~TGUI(void) {}

bool PointInRect(int X1, int Y1,int X2,int Y2,int Width,int Height)
{
	return (X1>X2)&&(X1<X2+Width)&&(Y1>Y2)&&(Y1<Y2+Height);
}

void TGUI::Init()	
{
	Count = 0;
	pause = false;
}

void TGUI::AddButton(int X, int Y, int Width, int Height, char *Caption)
{
	Buttons[Count].X = X;
	Buttons[Count].Y = Y;
	Buttons[Count].Width = Width;
	Buttons[Count].Height = Height;
	//Buttons[Count].Caption[0] = NULL;
	Buttons[Count].AddSize = 0;
	strcpy(Buttons[Count].Caption, Caption);
	Count++;
}

void TGUI::Draw()
{
	for( int i = 0; i < Count; i++ )
	{
		SSprite_Draw(TButton, Buttons[i].X - Buttons[i].AddSize, Buttons[i].Y - Buttons[i].AddSize, Buttons[i].Width + Buttons[i].AddSize * 2, Buttons[i].Height + Buttons[i].AddSize * 2);
		Text_Draw(Font, Buttons[i].X + (Buttons[i].Width - Text_GetWidth(Font, Buttons[i].Caption )) / 2, Buttons[i].Y + Buttons[i].Height / 2 - Font->Height / 2, Buttons[i].Caption);
	}
	SSprite_Draw(TCursor, Mouse_X() - 32, Mouse_Y() - 32, 64, 64, 255, Angle = (Angle + 5) % 360);
}

void TGUI::Process()
{
	for(int i = 0; i < Count; i++ )
		if(pause==false)
        {
			if(PointInRect(Mouse_X(),Mouse_Y(),Buttons[i].X,Buttons[i].Y,Buttons[i].Width,Buttons[i].Height))
			{
				if(Mouse_Click(M_LBUTTON)) ButtonPush(i);
				if(Buttons[i].AddSize < 4) ++Buttons[i].AddSize;
			}
            else if(Buttons[i].AddSize > 0) --Buttons[i].AddSize;

		}

    pause=false;
}

void TGUI::DelAll()
{
	Count=0;
	pause=true;
	Mouse_Click(M_LBUTTON);
}


//////////////
//**Player**//
//////////////
TPlayer::TPlayer(void) {}
TPlayer::~TPlayer(void) {}

void TPlayer::Init(int ShipType_)
{
    X = SCR_Width / 2;
    Y = SCR_Height / 2;
    AimAngle = 0;
    Temp = 0;
    Temp1 = 0;
    Power = 5;
    Bomb = 0;
    Score = 0;
    ShipType = ShipType_;
    Reload = 0;

    Width = 64;
    Height = 64;
    if (ShipType == 0)
    {
        ReloadTime = 10;
    	Size = 16;
        Speed = 10;
        TWind = Tex_LoadFromFile( "data\\grfx\\wind0.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
        TShip = Tex_LoadFromFile( "data\\grfx\\ship0.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
        TTurret = Tex_LoadFromFile( "data\\grfx\\turret0.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
     }
    else if (ShipType == 1)
    {
        ReloadTime = 10;
    	Size = 16;
        Speed = 10;
        TWind = Tex_LoadFromFile( "data\\grfx\\wind1.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
        TShip = Tex_LoadFromFile( "data\\grfx\\ship1.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
        TTurret = Tex_LoadFromFile( "data\\grfx\\turret1.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
     }
    else if (ShipType == 2)
    {
        ReloadTime = 10;
    	Size = 16;
        Speed = 10;
        TWind = Tex_LoadFromFile( "data\\grfx\\wind1.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
        TShip = Tex_LoadFromFile( "data\\grfx\\ship2.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
        TTurret = Tex_LoadFromFile( "data\\grfx\\turret1.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
     }
}

void TPlayer::Draw()
{
    switch(ShipType)
    {
        case 0:
        	SSprite_Draw(TShip, X - Width / 2, Y - Height / 2, Width, Height);
            for (int i = 0; i < Power; i++) SSprite_Draw(TTurret, X + Width * M_Cos(72 * i + Temp1) - TTurret->Width / 2, Y + Height * M_Sin(72 * i + Temp1) - TTurret->Height / 2, TTurret->Width, TTurret->Height, 255, AimAngle);
            Temp1 += 1;
           	SSprite_Draw(TWind, X - TWind->Width / 2, Y - TWind->Height / 2, TWind->Width, TWind->Height, 255, Temp += 10);
            break;
        case 1:
        	SSprite_Draw(TShip, X - Width / 2, Y - Height / 2, Width, Height);
            //for (int i = 0; i < Power; i++) SSprite_Draw(TTurret, X - Width * (.5 - M_Cos(72 * i + Temp1)), Y - Width * (.5 - M_Sin(72 * i + Temp1)), Width, Height, 255, AimAngle);
            //Temp1 += 3;
           	SSprite_Draw(TWind, X - Width, Y - Height / 2, Width, Height, 255, Temp + 10);
           	SSprite_Draw(TWind, X, Y - Height / 2, Width, Height, 255, Temp += 5);
            break;
        case 2:
        	SSprite_Draw(TShip, X - Width / 2, Y - Height / 2, Width, Height);
            //for (int i = 0; i < Power; i++) SSprite_Draw(TTurret, X - Width * (.5 - M_Cos(72 * i + Temp1)), Y - Width * (.5 - M_Sin(72 * i + Temp1)), Width, Height, 255, AimAngle);
            //Temp1 += 3;
           	SSprite_Draw(TWind, X - Width / 2, Y - Height / 2, Width, Height, 255, Temp += 10);
            break;
    }
}

void TPlayer::Process()
{
    AimAngle = M_FindAngle((int)Mouse_X(), (int)Mouse_Y(), (int)X, (int)Y);

    int Dx = 0;
    int Dy = 0;

    if (Key_Down(K_W)) Dy -= 10;
    if (Key_Down(K_S)) Dy += 10;
    if (Key_Down(K_A)) Dx -= 10;
    if (Key_Down(K_D)) Dx += 10;

    float Ox = X;
    float Oy = Y;


    for (int j = 0; j < EBullet.Count; j++)
    {
        if (M_Distance(X, Y, EBullet.Bullets[j].X, EBullet.Bullets[j].Y) <= Size + EBullet.Bullets[j].Size)
        {
            EBullet.Bullets[j].Kill = true;
            Power -= EBullet.Bullets[j].Damage;
        }
    }


    if (Dx != 0 || Dy != 0)
    {
        X += Speed * M_Cos(M_FindAngle(Dx, Dy, 0, 0));
        Y += Speed * M_Sin(M_FindAngle(Dx, Dy, 0, 0));
    }

    if (X - Size < 0 || X + Size > SCR_Width) X = Ox;
    if (Y - Size < 0 || Y + Size > SCR_Height) Y = Oy;

    if (Mouse_Down(M_LBUTTON) && Reload == 0)
    {
        Reload = ReloadTime;
        Player.Fire();
    }
    if (Reload > 0) --Reload;

    if (Power < 0) ButtonPush(10);
}

void TPlayer::Fire()
{
    switch(ShipType)
    {
        case 0:
            Bullet.AddBullet(X, Y, AimAngle, 32, 0, 0, 8, 2);
            Bullet.AddBullet(X + 16 * M_Cos(AimAngle + 90), Y + 16 * M_Sin(AimAngle + 90), AimAngle, 32, 0, 0, 8, 1);
            Bullet.AddBullet(X - 16 * M_Cos(AimAngle + 90), Y - 16 * M_Sin(AimAngle + 90), AimAngle, 32, 0, 0, 8, 1);
            for (int i = 0; i < Power; i++) Bullet.AddBullet(X + Width * M_Cos(72 * i + Temp1), Y + Width * M_Sin(72 * i + Temp1), AimAngle, 32, 0, 0, 8, 1);
            break;
        case 1:
            Bullet.AddBullet(X, Y, AimAngle, 0, 32, .5, 8, 2);
            for (int i = 0; i < Power + 2; i++) Bullet.AddBullet(X, Y, AimAngle - 15 + rand()%30, 0, 32, .5, 8, 1);
            break;
        case 2:
            Bullet.AddBullet(X, Y, AimAngle, 32, 0, 0, 8, 2);
            for (int i = 0; i < Power + 2; i++) Bullet.AddBullet(X + (i + 1) * 8 * M_Cos(AimAngle), Y + (i + 1) * 8 * M_Sin(AimAngle), AimAngle, 32, 0, 0, 8, 1);
            break;
    }
}

//////////////
//**Bullet**//
//////////////
TBullet::TBullet(void) {}
TBullet::~TBullet(void) {}

void TBullet::Init(int a)
{
    Count = 0;
    switch(a)
    {
        case 0:
            TexBullet = Tex_LoadFromFile("data\\grfx\\bullet.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA);
            break;
        case 1:
            TexBullet = Tex_LoadFromFile("data\\grfx\\bullet0.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA);
            break;
        case 2:
            TexBullet = Tex_LoadFromFile("data\\grfx\\bullet1.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA);
            break;
        case 3:
            TexBullet = Tex_LoadFromFile("data\\grfx\\bullet2.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA);
            break;
    }
}

void TBullet::AddBullet(float X, float Y, int Angle, float Speed, float MSpeed, float DSpeed, int Size, int Damage)
{
    if (Count < 500)
    {
    	Bullets[Count].X = X;
    	Bullets[Count].Y = Y;
    	Bullets[Count].Angle = Angle;
    	Bullets[Count].Speed = Speed;
    	Bullets[Count].MSpeed = MSpeed;
    	Bullets[Count].DSpeed = DSpeed;
    	Bullets[Count].Size = Size;
    	Bullets[Count].Damage = Damage;
        Bullets[Count].Kill = false;
    	Count++;
    }
}

void TBullet::Draw()
{
	for(int i = 0; i < Count; i++)
	{
		SSprite_Draw(TexBullet, Bullets[i].X - TexBullet->Width / 2, Bullets[i].Y - TexBullet->Height / 2, TexBullet->Width, TexBullet->Height, 255, Bullets[i].Angle);
	}
}

void TBullet::Process()
{
    int k = 0;
	for(int i = 0; i < Count; i++)
    {
        if (Bullets[i].DSpeed > 0)
        {
            if (Bullets[i].Speed < Bullets[i].MSpeed) Bullets[i].Speed += Bullets[i].DSpeed;
            else Bullets[i].DSpeed = 0;
        }
        else if (Bullets[i].DSpeed < 0)
        {
            if (Bullets[i].Speed > Bullets[i].MSpeed) Bullets[i].Speed += Bullets[i].DSpeed;
            else Bullets[i].DSpeed = 0;
        }
        Bullets[i].X += Bullets[i].Speed * M_Cos(Bullets[i].Angle);
        Bullets[i].Y += Bullets[i].Speed * M_Sin(Bullets[i].Angle);

        if (k > 0) Bullets[i - k] = Bullets[i];

        if ((Bullets[i].X < 0 || Bullets[i].X > SCR_Width || Bullets[i].Y < 0 || Bullets[i].Y > SCR_Height) || Bullets[i].Kill == true) ++k;
    }
    Count -= k;
}




/////////////
//**Enemy**//
/////////////
TEnemy::TEnemy(void) {}
TEnemy::~TEnemy(void) {}

void TEnemy::Init()
{
    Count = 0;
}

void TEnemy::AddEnemy(float X, float Y, int EnemyType, int Angle)
{
    if (Count < 100)
    {
    	Enemys[Count].X = X;
    	Enemys[Count].Y = Y;
    	Enemys[Count].Reload = 0;

    	Enemys[Count].EnemyType = EnemyType;

    	Enemys[Count].Stance = Spawn;

        Enemys[Count].Speed = EnemyDat[EnemyType][0];
        Enemys[Count].Size = EnemyDat[EnemyType][1];
        Enemys[Count].HP = EnemyDat[EnemyType][2];
        Enemys[Count].ReloadTime = EnemyDat[EnemyType][3];
        Enemys[Count].ShootType = EnemyDat[EnemyType][4];

//        Enemys[Count].Angle = M_FindAngle(SCR_Width / 2, SCR_Height / 2, (int)X, (int)Y);
        Enemys[Count].Angle = Angle;

        Enemys[Count].Temp = 0;
        Enemys[Count].Temp1 = 0;
        Enemys[Count].Temp2 = 0;

    	Count++;
    }
}

void TEnemy::Draw()
{
	for(int i = 0; i < Count; i++)
	{
		SSprite_Draw(TexEnemy[Enemys[i].EnemyType], Enemys[i].X - TexEnemy[Enemys[i].EnemyType]->Width / 2, Enemys[i].Y - TexEnemy[Enemys[i].EnemyType]->Height / 2, TexEnemy[Enemys[i].EnemyType]->Width, TexEnemy[Enemys[i].EnemyType]->Height, 255, Enemys[i].Angle);
	}
}

void TEnemy::Process()
{
    int k = 0;
	for(int i = 0; i < Count; i++)
    {
        if (Enemys[i].Reload > 0 && M_Distance(Enemys[i].X, Enemys[i].Y, Player.X, Player.Y) > Enemys[i].Size + Player.Size) --Enemys[i].Reload;
        Enemys[i].X += Enemys[i].Speed * M_Cos(Enemys[i].Angle);
        Enemys[i].Y += Enemys[i].Speed * M_Sin(Enemys[i].Angle);

        for (int j = 0; j < Bullet.Count; j++)
        {
            if (M_Distance(Enemys[i].X, Enemys[i].Y, Bullet.Bullets[j].X, Bullet.Bullets[j].Y) <= Enemys[i].Size + Bullet.Bullets[j].Size)
            {
                Bullet.Bullets[j].Kill = true;
                Enemys[i].HP -= Bullet.Bullets[j].Damage;
            }
        }


        if (Enemys[i].Stance != Spawn && Enemys[i].Reload == 0) Fire(i);
        if (Enemys[i].Stance == Spawn && Enemys[i].X > 0 && Enemys[i].X < SCR_Width && Enemys[i].Y > 0 && Enemys[i].Y < SCR_Height) Enemys[i].Stance = Go;

        if (k > 0) Enemys[i - k] = Enemys[i];

        if (Enemys[i].HP <= 0 || (Enemys[i].Stance == Go && (Enemys[i].X + TexEnemy[Enemys[i].EnemyType]->Width < 0 || Enemys[i].X - TexEnemy[Enemys[i].EnemyType]->Width> SCR_Width || Enemys[i].Y + TexEnemy[Enemys[i].EnemyType]->Height< 0 || Enemys[i].Y - TexEnemy[Enemys[i].EnemyType]->Height> SCR_Height))) ++k;

        if (Enemys[i].HP <= 0)
        {
            ++Player.Score;
            for (int e = 0; e < 25; e++)
            {
                if (Boom[e].Alpha < 128)
                {
                    Boom[e].Alpha = 255;
                    Boom[e].Size = 32;
                    Boom[e].X = Enemys[i].X;
                    Boom[e].Y = Enemys[i].Y;
                    break;
                }
            }
            if (rand()%10 == 0)
            {
                for (int e = 0; e < 5; e++)
                {
                    if (Bonus[e].Alpha <= 128)
                    {
                        Bonus[e].Alpha = 255;
                        Bonus[e].Size = 32;
                        Bonus[e].X = Enemys[i].X;
                        Bonus[e].Y = Enemys[i].Y;
                        break;
                    }
                }
            }
        }

    }
    Count -= k;
}

void TEnemy::Fire(int i)
{
    switch(Enemys[i].ShootType)
    {
        case 0:
            Enemys[i].Reload = Enemys[i].ReloadTime;
            EBullet.AddBullet(Enemys[i].X, Enemys[i].Y, M_FindAngle((int)Player.X, (int)Player.Y, (int)Enemys[i].X, (int)Enemys[i].Y), 6, 0, 0, 8, 1);
            break;
        case 1:
            Enemys[i].Reload = Enemys[i].ReloadTime;
            for (int j = 0; j < 5; j++)
                EBullet.AddBullet(Enemys[i].X, Enemys[i].Y, M_FindAngle((int)Player.X, (int)Player.Y, (int)Enemys[i].X, (int)Enemys[i].Y), 6 + j, -.5, 6, 8, 1);
            break;
        case 2:
            if (Enemys[i].Temp < 360)
            {
                if (Enemys[i].Temp1 == 0)
                {
                    EBullet.AddBullet(Enemys[i].X, Enemys[i].Y, Enemys[i].Temp, 6, 0, 0, 8, 1);
                    Enemys[i].Temp += 15;
                    Enemys[i].Temp1 = 0;
                }
                else
                {
                    --Enemys[i].Temp1;
                }
            }
            else
            {
                Enemys[i].Reload = Enemys[i].ReloadTime;
                Enemys[i].Temp = 0;
                Enemys[i].Temp1 = 0;
            }
            break;
        case 3:
            if (Enemys[i].Temp < 360)
            {
                if (Enemys[i].Temp1 == 0)
                {
                    EBullet.AddBullet(Enemys[i].X, Enemys[i].Y, Enemys[i].Temp, 6, 0, 0, 8, 1);
                    EBullet.AddBullet(Enemys[i].X, Enemys[i].Y, 180 + Enemys[i].Temp, 6, 0, 0, 8, 1);
                    Enemys[i].Temp += 15;
                    Enemys[i].Temp1 = 1;
                }
                else
                {
                    --Enemys[i].Temp1;
                }
            }
            else
            {
                Enemys[i].Reload = Enemys[i].ReloadTime;
                Enemys[i].Temp = 0;
                Enemys[i].Temp1 = 0;
            }
            break;
    }
}


///////////////
//****   ****//
///////////////

void Init()
{
    Font = Text_LoadFontFromFile("data\\grfx\\Font.tga", "data\\grfx\\Font.ofi", 0, TEX_DEFAULT_2D | TEXTYPE_TGA );

    TBonus = Tex_LoadFromFile( "data\\grfx\\bonus.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    TButton = Tex_LoadFromFile( "data\\grfx\\button.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
	TCursor = Tex_LoadFromFile("data\\grfx\\Cursor.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );

    TNicola = Tex_LoadFromFile( "data\\grfx\\Nicola.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    TLina = Tex_LoadFromFile( "data\\grfx\\Lina.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    THof_Tof = Tex_LoadFromFile( "data\\grfx\\Hof_Tof.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    TMenuBack = Tex_LoadFromFile( "data\\grfx\\MenuBack.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );

    TBoom = Tex_LoadFromFile( "data\\grfx\\boom.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );

    Enemy.TexEnemy[0] = Tex_LoadFromFile( "data\\grfx\\enemy0.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[1] = Tex_LoadFromFile( "data\\grfx\\enemy1.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[2] = Tex_LoadFromFile( "data\\grfx\\enemy2.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[3] = Tex_LoadFromFile( "data\\grfx\\enemy3.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[4] = Tex_LoadFromFile( "data\\grfx\\enemy4.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[5] = Tex_LoadFromFile( "data\\grfx\\enemy5.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[6] = Tex_LoadFromFile( "data\\grfx\\enemy6.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[7] = Tex_LoadFromFile( "data\\grfx\\enemy7.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[8] = Tex_LoadFromFile( "data\\grfx\\enemy8.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );
    Enemy.TexEnemy[9] = Tex_LoadFromFile( "data\\grfx\\enemy9.tga", -1, TEX_DEFAULT_2D | TEXTYPE_TGA );

    if (Snd_Init())
    {
//        SExplode = Snd_LoadFromFile(".\\data\\sound\\explode.wav", 5);

        Song = SongLoadFromFile("data\\music\\ingame.xm");
//        Song = SongLoadFromFile("data\\music\\inmenu.xm");
        SongPlay(Song);

        Sound = true;
    }
    else
    {
        Sound = false;
    }

    GameStatus = MainMenu;
    Back = 0;
    SpawnT = 0;
    SpawnTime = 200;

    GUI.Init();
    MenuInit();
}

void Process()
{
    if (Key_Press(K_ESCAPE)) ButtonPush(10);

    Back = (++Back)%128 - 128;

    switch(GameStatus)
    {
        case MainMenu:
        {
            GUI.Process();
            break;
        }
        case ShipMenu:
        {
            GUI.Process();
            break;
        }
        case Game:
        {
            Player.Process();
            Bullet.Process();
            EBullet.Process();
            Enemy.Process();

//    if (Key_Press(K_SPACE)) Enemy.AddEnemy(rand()%1000, -100, rand()%10);
            if (SpawnT > 0) --SpawnT;
            else
            {
                int k = rand()%360;
                Enemy.AddEnemy(SCR_Width / 2 - M_Cos(k) * 1000, SCR_Height / 2 - M_Sin(k) * 1000, rand()%10, k);
                SpawnT = SpawnTime - 20 * Player.Power - Player.Score / 10;
            }

            for (int i = 0; i < 25; i++)
            {
                if (Boom[i].Alpha > 128)
                {
                    Boom[i].Alpha -= 2;
                    Boom[i].Size += 6;
                }
            }

            for (int i = 0; i < 5; i++)
            {
                if (Bonus[i].Alpha > 128)
                {
                    Bonus[i].Alpha -= 1;
                    if (M_Distance(Player.X, Player.Y, Bonus[i].X, Bonus[i].Y) < Bonus[i].Size * 2 + Player.Size)
                    {
                        if (Player.Power < 5)
                        {
                            ++Player.Power;
                            Bonus[i].Alpha = 0;
                        }
                    }
                }
            }

            break;
        }
    }
}

void Draw()
{
    switch(GameStatus)
    {
        case MainMenu:
            STile_Draw(TMenuBack, - 128 + M_Cos(360 * Back / 128) * 64, Back, 128, 128, SCR_Width / 128 + 2, SCR_Height / 128 + 2);

            GUI.Draw();
            break;
        case ShipMenu:
            STile_Draw(TMenuBack, - 128 + M_Cos(360 * Back / 128) * 64, Back, 128, 128, SCR_Width / 128 + 2, SCR_Height / 128 + 2);

            SSprite_Draw(TNicola, SCR_Width / 4 - 128, 128, 256, 512);
            SSprite_Draw(TLina, 2 * SCR_Width / 4 - 128, 128, 256, 512);
            SSprite_Draw(THof_Tof, 3 * SCR_Width / 4 - 128, 128, 256, 512);
            GUI.Draw();
            break;
        case Game:
            STile_Draw(TMenuBack, - 128 + M_Cos(360 * Back / 128) * 64, Back, 128, 128, SCR_Width / 128 + 2, SCR_Height / 128 + 2);

            Player.Draw();
            Enemy.Draw();
            Bullet.Draw();
            EBullet.Draw();

            FX_SetBlendMode(FX_BLEND_ADD);
            for (int i = 0; i < 25; i++)
            {
                if (Boom[i].Alpha > 15) SSprite_Draw(TBoom, Boom[i].X - Boom[i].Size / 2, Boom[i].Y - Boom[i].Size / 2, Boom[i].Size, Boom[i].Size, Boom[i].Alpha, Boom[i].Alpha * 2);
            }
            FX_SetBlendMode(FX_BLEND_NORMAL);

            for (int i = 0; i < 5; i++)
            {
                if (Bonus[i].Alpha > 128) SSprite_Draw(TBonus, Bonus[i].X  - 32, Bonus[i].Y - 32, 64, 64, Bonus[i].Alpha, Bonus[i].Alpha * 3);
            }

            GUI.Draw();
            break;
    }
}

void ButtonPush(int ButtonKey)
{
    if (GameStatus == MainMenu)
    {
        switch (ButtonKey)
        {
            case 0:
                GameStatus = ShipMenu;
                MenuInit();
                break;
            case 10:
            case 1:
                Quit();
                break;
        }
    }
    else if (GameStatus == ShipMenu)
    {
        switch (ButtonKey)
        {
            case 0:
            case 1:
            case 2:
                Player.Init(ButtonKey);
                Bullet.Init(ButtonKey + 1);
                EBullet.Init(0);
                Enemy.Init();
                GameStatus = Game;
                MenuInit();
                break;
            case 10:
                GameStatus = MainMenu;
                MenuInit();
                break;
        }
    }
    else if (GameStatus == Game)
    {
        switch (ButtonKey)
        {
            case 10:
                GameStatus = MainMenu;
                MenuInit();
                break;
        }
    }
}

void MenuInit()
{
	switch(GameStatus)
    {
        case MainMenu:
        {
			GUI.DelAll();
			GUI.AddButton(M_Round(SCR_Width / 2 - 128), 300, 256, 64, "New game");
			GUI.AddButton(M_Round(SCR_Width / 2 - 128), 500, 256, 64, "Exit");
			break;
        }
        case ShipMenu:
        {
			GUI.DelAll();
			GUI.AddButton(M_Round(SCR_Width / 4 - 128), 600, 256, 64, "Nicola");
			GUI.AddButton(M_Round(SCR_Width * 2 / 4 - 128), 600, 256, 64, "Lina");
			GUI.AddButton(M_Round(SCR_Width * 3 / 4 - 128), 600, 256, 64, "Hof-Tof");
			break;
        }
		case Game:
        {
			GUI.DelAll();
			break;
        }
	}
}

void Quit()
{
//    SongFree(Song);
    OE_Quit();
}

int main()
{
    time_t current_time = time(NULL);
    srand((unsigned int) current_time);

    LoadOMEGA("OMEGA.dll");

    Timer_Create((void*)Process , 20, 0);
    Timer_Create((void*)Draw, 16.6666, 1);

    //OE_RegProcedure(SYS_LOAD, (void*)Load); //    
    OE_RegProcedure(SYS_INIT, (void*)Init); // 
    //OE_RegProcedure(SYS_DRAW, (void*)Draw); // 
    OE_RegProcedure(SYS_QUIT, (void*)Quit); //  

	OE_SetScreenOptions(SCR_Width , SCR_Height, 32, 0, true, false);
    OE_SetAdvancedOptions(false, true, true);

	OE_Init();
}

